/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.model.tv;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.omertron.themoviedbapi.enumeration.ArtworkType;
import com.omertron.themoviedbapi.enumeration.TVSeasonMethod;
import com.omertron.themoviedbapi.interfaces.AppendToResponse;
import com.omertron.themoviedbapi.model.artwork.Artwork;
import com.omertron.themoviedbapi.model.media.MediaCreditList;
import com.omertron.themoviedbapi.model.media.Video;
import com.omertron.themoviedbapi.model.person.ExternalID;
import com.omertron.themoviedbapi.model.tv.TVEpisodeInfo;
import com.omertron.themoviedbapi.model.tv.TVSeasonBasic;
import com.omertron.themoviedbapi.results.WrapperGenericList;
import com.omertron.themoviedbapi.results.WrapperImages;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class TVSeasonInfo
extends TVSeasonBasic
implements Serializable,
AppendToResponse<TVSeasonMethod> {
    private static final long serialVersionUID = 100L;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="overview")
    private String overview;
    @JsonProperty(value="episodes")
    private List<TVEpisodeInfo> episodes;
    private final Set<TVSeasonMethod> methods = EnumSet.noneOf(TVSeasonMethod.class);
    private MediaCreditList credits = new MediaCreditList();
    private ExternalID externalIDs = new ExternalID();
    private List<Artwork> images = Collections.emptyList();
    private List<Video> videos = Collections.emptyList();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOverview() {
        return this.overview;
    }

    public void setOverview(String overview) {
        this.overview = overview;
    }

    public List<TVEpisodeInfo> getEpisodes() {
        return this.episodes;
    }

    public void setEpisodes(List<TVEpisodeInfo> episodes) {
        this.episodes = episodes;
    }

    private void addMethod(TVSeasonMethod method) {
        this.methods.add(method);
    }

    @Override
    public boolean hasMethod(TVSeasonMethod method) {
        return this.methods.contains(method);
    }

    @JsonSetter(value="credits")
    public void setCredits(MediaCreditList credits) {
        this.credits = credits;
        this.addMethod(TVSeasonMethod.CREDITS);
    }

    @JsonSetter(value="external_ids")
    public void setExternalIDs(ExternalID externalIDs) {
        this.externalIDs = externalIDs;
        this.addMethod(TVSeasonMethod.EXTERNAL_IDS);
    }

    @JsonSetter(value="images")
    public void setImages(WrapperImages images) {
        this.images = images.getAll(new ArtworkType[0]);
        this.addMethod(TVSeasonMethod.IMAGES);
    }

    @JsonSetter(value="videos")
    public void setVideos(WrapperGenericList<Video> videos) {
        this.videos = videos.getResults();
        this.addMethod(TVSeasonMethod.VIDEOS);
    }

    public MediaCreditList getCredits() {
        return this.credits;
    }

    public ExternalID getExternalIDs() {
        return this.externalIDs;
    }

    public List<Artwork> getImages() {
        return this.images;
    }

    public List<Video> getVideos() {
        return this.videos;
    }
}

