/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.tools;

import com.omertron.themoviedbapi.tools.MethodBase;
import com.omertron.themoviedbapi.tools.MethodSub;
import com.omertron.themoviedbapi.tools.Param;
import com.omertron.themoviedbapi.tools.TmdbParameters;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiUrl {
    private static final Logger LOG = LoggerFactory.getLogger(ApiUrl.class);
    private static final String TMDB_API_BASE = "http://api.themoviedb.org/3/";
    private static final String DELIMITER_FIRST = "?";
    private static final String DELIMITER_SUBSEQUENT = "&";
    private final String apiKey;
    private final MethodBase method;
    private MethodSub submethod = MethodSub.NONE;
    private static final List<Param> IGNORE_PARAMS = new ArrayList<Param>();

    public ApiUrl(String apiKey, MethodBase method) {
        this.apiKey = apiKey;
        this.method = method;
    }

    public ApiUrl subMethod(MethodSub submethod) {
        if (submethod != MethodSub.NONE) {
            this.submethod = submethod;
        }
        return this;
    }

    public URL buildUrl() {
        return this.buildUrl(new TmdbParameters());
    }

    public URL buildUrl(TmdbParameters params) {
        StringBuilder urlString = new StringBuilder(TMDB_API_BASE);
        LOG.trace("Method: '{}', Sub-method: '{}', Params: {}", new Object[]{this.method.getValue(), this.submethod.getValue(), ToStringBuilder.reflectionToString((Object)params, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE)});
        if (this.method == MethodBase.SEASON || this.method == MethodBase.EPISODE) {
            urlString.append(MethodBase.TV.getValue());
        } else {
            urlString.append(this.method.getValue());
        }
        if (params.has(Param.QUERY)) {
            urlString.append((CharSequence)this.queryProcessing(params));
        } else {
            urlString.append((CharSequence)this.idProcessing(params));
        }
        urlString.append((CharSequence)this.otherProcessing(params));
        try {
            LOG.trace("URL: {}", (Object)urlString.toString());
            return new URL(urlString.toString());
        }
        catch (MalformedURLException ex) {
            LOG.warn("Failed to create URL {} - {}", (Object)urlString.toString(), (Object)ex.getMessage());
            return null;
        }
    }

    private StringBuilder queryProcessing(TmdbParameters params) {
        StringBuilder urlString = new StringBuilder();
        if (this.submethod != MethodSub.NONE) {
            urlString.append("/").append(this.submethod.getValue());
        }
        urlString.append(DELIMITER_FIRST).append(Param.API_KEY.getValue()).append(this.apiKey).append(DELIMITER_SUBSEQUENT).append(Param.QUERY.getValue());
        String query = (String)params.get(Param.QUERY);
        try {
            urlString.append(URLEncoder.encode(query, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            LOG.trace("Unable to encode query: '{}' trying raw.", (Object)query, (Object)ex);
            urlString.append(query);
        }
        return urlString;
    }

    private StringBuilder idProcessing(TmdbParameters params) {
        StringBuilder urlString = new StringBuilder();
        if (params.has(Param.ID)) {
            urlString.append("/").append(params.get(Param.ID));
        }
        if (params.has(Param.SEASON_NUMBER)) {
            urlString.append("/season/").append(params.get(Param.SEASON_NUMBER));
        }
        if (params.has(Param.EPISODE_NUMBER)) {
            urlString.append("/episode/").append(params.get(Param.EPISODE_NUMBER));
        }
        if (this.submethod != MethodSub.NONE) {
            urlString.append("/").append(this.submethod.getValue());
        }
        urlString.append(DELIMITER_FIRST).append(Param.API_KEY.getValue()).append(this.apiKey);
        return urlString;
    }

    private StringBuilder otherProcessing(TmdbParameters params) {
        StringBuilder urlString = new StringBuilder();
        for (Map.Entry<Param, String> argEntry : params.getEntries()) {
            if (IGNORE_PARAMS.contains((Object)argEntry.getKey())) continue;
            urlString.append(DELIMITER_SUBSEQUENT).append(argEntry.getKey().getValue()).append(argEntry.getValue());
        }
        return urlString;
    }

    static {
        IGNORE_PARAMS.add(Param.ID);
        IGNORE_PARAMS.add(Param.QUERY);
        IGNORE_PARAMS.add(Param.SEASON_NUMBER);
        IGNORE_PARAMS.add(Param.EPISODE_NUMBER);
    }
}

