/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.tools;

import com.omertron.themoviedbapi.MovieDbException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.yamj.api.common.exception.ApiExceptionType;
import org.yamj.api.common.http.DigestedResponse;
import org.yamj.api.common.http.DigestedResponseReader;

public class HttpTools {
    private final HttpClient httpClient;
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String APPLICATION_JSON = "application/json";
    private static final long RETRY_DELAY = 1L;
    private static final int RETRY_MAX = 5;
    private static final int STATUS_TOO_MANY_REQUESTS = 429;

    public HttpTools(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getRequest(URL url) throws MovieDbException {
        try {
            HttpGet httpGet = new HttpGet(url.toURI());
            httpGet.addHeader("Accept", APPLICATION_JSON);
            DigestedResponse response = DigestedResponseReader.requestContent((HttpClient)this.httpClient, (HttpGet)httpGet, (Charset)CHARSET);
            long retryCount = 0L;
            while (response.getStatusCode() == 429 && retryCount++ <= 5L) {
                this.delay(retryCount);
                response = DigestedResponseReader.requestContent((HttpClient)this.httpClient, (HttpGet)httpGet, (Charset)CHARSET);
            }
            return this.validateResponse(response, url);
        }
        catch (IOException | URISyntaxException ex) {
            throw new MovieDbException(ApiExceptionType.CONNECTION_ERROR, null, url, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw new MovieDbException(ApiExceptionType.HTTP_503_ERROR, "Service Unavailable", url, (Throwable)ex);
        }
    }

    private void delay(long multiplier) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L * multiplier));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String deleteRequest(URL url) throws MovieDbException {
        try {
            HttpDelete httpDel = new HttpDelete(url.toURI());
            return this.validateResponse(DigestedResponseReader.deleteContent((HttpClient)this.httpClient, (HttpDelete)httpDel, (Charset)CHARSET), url);
        }
        catch (IOException | URISyntaxException ex) {
            throw new MovieDbException(ApiExceptionType.CONNECTION_ERROR, null, url, (Throwable)ex);
        }
    }

    public String postRequest(URL url, String jsonBody) throws MovieDbException {
        try {
            HttpPost httpPost = new HttpPost(url.toURI());
            httpPost.addHeader("Content-Type", APPLICATION_JSON);
            httpPost.addHeader("Accept", APPLICATION_JSON);
            StringEntity params = new StringEntity(jsonBody, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)params);
            return this.validateResponse(DigestedResponseReader.postContent((HttpClient)this.httpClient, (HttpPost)httpPost, (Charset)CHARSET), url);
        }
        catch (IOException | URISyntaxException ex) {
            throw new MovieDbException(ApiExceptionType.CONNECTION_ERROR, null, url, (Throwable)ex);
        }
    }

    private String validateResponse(DigestedResponse response, URL url) throws MovieDbException {
        if (response.getStatusCode() == 0) {
            throw new MovieDbException(ApiExceptionType.CONNECTION_ERROR, response.getContent(), response.getStatusCode(), url, null);
        }
        if (response.getStatusCode() >= 500) {
            throw new MovieDbException(ApiExceptionType.HTTP_503_ERROR, response.getContent(), response.getStatusCode(), url, null);
        }
        if (response.getStatusCode() >= 300) {
            throw new MovieDbException(ApiExceptionType.HTTP_404_ERROR, response.getContent(), response.getStatusCode(), url, null);
        }
        return response.getContent();
    }
}

