/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.tools;

import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public enum MethodBase {
    ACCOUNT("account"),
    AUTH("authentication"),
    CERTIFICATION("certification"),
    COLLECTION("collection"),
    COMPANY("company"),
    CONFIGURATION("configuration"),
    CREDIT("credit"),
    DISCOVER("discover"),
    EPISODE("episode"),
    FIND("find"),
    GENRE("genre"),
    GUEST_SESSION("guest_session"),
    JOB("job"),
    KEYWORD("keyword"),
    LIST("list"),
    MOVIE("movie"),
    NETWORK("network"),
    PERSON("person"),
    REVIEW("review"),
    SEARCH("search"),
    SEASON("season"),
    TIMEZONES("timezones"),
    TV("tv");

    private final String value;

    private MethodBase(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static MethodBase fromString(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            for (MethodBase method : EnumSet.allOf(MethodBase.class)) {
                if (!value.equalsIgnoreCase(method.value)) continue;
                return method;
            }
        }
        throw new IllegalArgumentException("Method '" + value + "' not recognised");
    }
}

