/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.omertron.themoviedbapi.MovieDbException;
import com.omertron.themoviedbapi.tools.PostBody;
import java.util.HashMap;
import java.util.Map;
import org.yamj.api.common.exception.ApiExceptionType;

public class PostTools {
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    private final Map<String, Object> values = new HashMap<String, Object>();

    public PostTools add(PostBody key, Object value) {
        this.values.put(key.getValue(), value);
        return this;
    }

    public PostTools add(String key, Object value) {
        this.values.put(key, value);
        return this;
    }

    public String build() throws MovieDbException {
        return this.convertToJson(this.values);
    }

    private String convertToJson(Map<String, ?> map) throws MovieDbException {
        try {
            return MAPPER.writeValueAsString(map);
        }
        catch (JsonProcessingException ex) {
            throw new MovieDbException(ApiExceptionType.MAPPING_FAILED, "JSON conversion failed", "", (Throwable)ex);
        }
    }
}

