/*
 * Decompiled with CFR 0.152.
 */
package com.omertron.themoviedbapi.tools;

import com.omertron.themoviedbapi.tools.Param;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class TmdbParameters {
    private final Map<Param, String> parameters = new EnumMap<Param, String>(Param.class);

    public Set<Map.Entry<Param, String>> getEntries() {
        return this.parameters.entrySet();
    }

    public void add(Param key, String[] value) {
        if (value != null && value.length > 0) {
            this.parameters.put(key, this.toList(value));
        }
    }

    public void add(Param key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.parameters.put(key, value);
        }
    }

    public void add(Param key, Integer value) {
        if (value != null && value > 0) {
            this.parameters.put(key, String.valueOf(value));
        }
    }

    public void add(Param key, Float value) {
        if (value != null && value.floatValue() > 0.0f) {
            this.parameters.put(key, String.valueOf(value));
        }
    }

    public void add(Param key, Boolean value) {
        if (value != null) {
            this.parameters.put(key, String.valueOf(value));
        }
    }

    public boolean has(Param key) {
        return this.parameters.containsKey((Object)key);
    }

    public Object get(Param key) {
        return this.parameters.get((Object)key);
    }

    public void remove(Param key) {
        this.parameters.remove((Object)key);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public String toList(String[] appendToResponse) {
        StringBuilder sb = new StringBuilder();
        boolean first = Boolean.TRUE;
        for (String append : appendToResponse) {
            if (first) {
                first = Boolean.FALSE;
            } else {
                sb.append(",");
            }
            sb.append(append);
        }
        return sb.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this.parameters, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

