package com.ott.stream.rapid.agent;

import com.fasterxml.jackson.databind.ObjectMapper;

import android.util.Log;

import com.vms.metric.sender.model.MetricMessage;
import com.vms.metric.sender.service.MetricSenderConfig;
import com.vms.metric.sender.util.Base64Util;
import com.vms.metric.sender.util.DeflateUtil;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class RapidMetricSender {
    private static boolean isInit = false;
    private String appId;
    private String appKey;
    private int postBatchSize;
    private int postBatchInterval;
    private boolean debug;
    private final List<String> serverRealmNames = new ArrayList<>();
    private final Random random = new Random();
    private BlockingQueue<MetricMessage> bufferQueue;
    private List<MetricMessage> list;
    private Long lastSendTimeMillis;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Map<String, RapidMetricSender> senders = new HashMap<>();

    public RapidMetricSender() {
    }

    public static void init(String appId, String appKey, Map<String, String[]> map, int postBatchSize, int postBatchInterval, boolean debug) {
        try {
            if (isInit) {
                return;
            }

            for (String key : map.keySet()) {
                MetricSenderConfig metricConfig = new MetricSenderConfig();
                metricConfig.setAppId(appId);
                metricConfig.setAppKey(appKey);
                metricConfig.setServerUrl((String[]) map.get(key));
                metricConfig.setPostBatchSize(postBatchSize);
                metricConfig.setPostBatchInterval(postBatchInterval);
                metricConfig.setDebug(debug);
                senders.put(key, (new RapidMetricSender()).initInstance(metricConfig));
            }

            isInit = true;
        } catch (Exception var9) {
            Log.i("RapidMetricSender", "init error : " + var9);
        }

    }

    public static void init(String appId, String appKey, Map<String, String[]> map) {
        init(appId, appKey, map, 100, 60000, false);
    }

    public static void setPostBatchConfig(String key, int postBatchSize, int postBatchInterval) {
        if (senders.containsKey(key) && postBatchSize > 0 && postBatchInterval > 0) {
            RapidMetricSender sender = senders.get(key);
            if (sender != null) {
                sender.postBatchSize = postBatchSize;
                sender.postBatchInterval = postBatchInterval;
            }
        }

    }

    public static void put(String key, String eventName, Map<String, Object> fieldsMap) {
        if (senders.containsKey(key)) {
            RapidMetricSender sender = senders.get(key);
            if (sender != null) {
                sender.put(eventName, fieldsMap);
            }
        }

    }

    private RapidMetricSender initInstance(MetricSenderConfig metricConfig) {
        this.appId = metricConfig.getAppId();
        this.appKey = metricConfig.getAppKey();

        for (String appendServerUrl : metricConfig.getServerUrl()) {
            if (!appendServerUrl.endsWith("/")) {
                appendServerUrl = appendServerUrl + "/";
            }

            this.serverRealmNames.add(appendServerUrl);
        }

        this.bufferQueue = new ArrayBlockingQueue<>(metricConfig.getBufferQueueSize());
        this.postBatchSize = metricConfig.getPostBatchSize();
        this.postBatchInterval = metricConfig.getPostBatchInterval();
        this.debug = metricConfig.isDebug();
        this.list = new ArrayList<>();
        this.lastSendTimeMillis = System.currentTimeMillis();
        (new Thread(new Runnable() {
            public void run() {
                RapidMetricSender.this.postRunnable();
            }
        }, "postRunnable")).start();
        return this;
    }

    private void put(String eventName, Map<String, Object> fieldsMap) {
        if (isInit && fieldsMap != null && !fieldsMap.isEmpty()) {
            this.bufferQueue.offer(new MetricMessage(eventName, fieldsMap));
        }

    }

    private void postRunnable() {
        while (true) {
            try {
                MetricMessage wrapperEntity = (MetricMessage) this.bufferQueue.poll((long) this.postBatchInterval, TimeUnit.MILLISECONDS);
                if (wrapperEntity != null) {
                    this.list.add(wrapperEntity);
                    if (this.list.size() >= this.postBatchSize) {
                        this.send(this.list);
                        this.lastSendTimeMillis = System.currentTimeMillis();
                        this.list.clear();
                    } else if (System.currentTimeMillis() - this.lastSendTimeMillis >= (long) this.postBatchInterval) {
                        this.send(this.list);
                        this.lastSendTimeMillis = System.currentTimeMillis();
                        this.list.clear();
                    }
                } else if (!this.list.isEmpty()) {
                    this.send(this.list);
                    this.lastSendTimeMillis = System.currentTimeMillis();
                    this.list.clear();
                }
            } catch (Exception e) {
                if (this.debug) {
                    System.out.println("store data error:" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    private void send(List<MetricMessage> list) {
        boolean result = false;
        List<String> availableUrls = new ArrayList<>(this.serverRealmNames);

        while (!result && !availableUrls.isEmpty()) {
            String url = (String) availableUrls.get(this.random.nextInt(availableUrls.size()));
            result = this.httpPost(list, url);
            if (!result) {
                availableUrls.remove(url);
            }
        }

    }

    private boolean httpPost(List<MetricMessage> list, String serverUrl) {
        HttpURLConnection urlConnection = null;
        boolean result = false;

        try {
            if (this.debug) {
                System.out.println("serverUrl:" + serverUrl + " send data,size:" + list.size());
            }

            URL url = new URL(serverUrl + "metric/batchpost/v1");
            urlConnection = (HttpURLConnection) url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setReadTimeout(5000);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConnection.setRequestProperty("charset", "utf-8");
            urlConnection.setRequestProperty("User-Agent", "MetricAgent 1.0");
            urlConnection.setUseCaches(false);
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            OutputStream outputStream = urlConnection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
            String value = Base64Util.getEncoder().encodeToString(DeflateUtil.compressStr(objectMapper.writeValueAsString(list)));
            Map<String, String> writeMap = new HashMap<>();
            writeMap.put("value", value);
            writeMap.put("appId", this.appId);
            writeMap.put("appKey", this.appKey);
            writer.write(this.getPostDataString(writeMap));
            writer.flush();
            writer.close();
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                result = true;
                if (this.debug) {
                    System.out.println("send package success");
                }
            } else {
                result = false;
                if (this.debug) {
                    System.out.printf("send package failed[%s]%n", responseCode);
                }
            }

            outputStream.close();
        } catch (Exception e) {
            if (this.debug) {
                System.out.println("send package error:" + e);
            }
        } finally {
            if (urlConnection != null) {
                try {
                    urlConnection.getInputStream().close();
                    urlConnection.disconnect();
                } catch (Exception var18) {
                    Log.i("RapidMetricSender", "close url connection error : " + var18);
                }
            }

        }

        return result;
    }

    private String getPostDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;

        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }

            result.append(URLEncoder.encode((String) entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode((String) entry.getValue(), "UTF-8"));
        }

        return result.toString();
    }
}
