package com.ott.stream.rapid.agent.debug;

import android.text.TextUtils;
import android.util.Pair;

import com.ott.stream.rapid.agent.utils.CommonUtil;
import com.ott.stream.rapid.agent.utils.LogUtil;
import com.ott.stream.rapid.agent.utils.SPUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class DebugConfig {
    private static final String TAG = "DebugConfig";

    public static final int DEBUG_WHAT_IJK_ERROR = -10000;
    public static final int DEBUG_WHAT_CRASH = -20000;
    public static final int DEBUG_WHAT_COMMON = -20001;

    public static final int DEBUG_EXTRA_COMMON_STARTUP_LONG = 1;

    public static boolean sEnable;
    public static long sStartLogTimestamp;
    public static long sEndLogTimestamp;
    public static int sLogTimesDaily;
    public static int sSingleLogSizeMB;
    public static List<Pair<Integer, Integer>> sTriggerEvents = new ArrayList<>();
    public static String sLogServer;
    public static int sLogcatSeconds;

    private static int sTodayTimes;

    private static boolean sValidLogParams = false;

    public static void parse(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        try {
            sEnable = jsonObject.getBoolean("enable");
            sStartLogTimestamp = jsonObject.getLong("start");
            sEndLogTimestamp = jsonObject.getLong("end");
            sLogTimesDaily = jsonObject.getInt("daily");
            sSingleLogSizeMB = jsonObject.getInt("size");
            String trigger = jsonObject.getString("events");
            parseTriggerEvents(trigger);
            sLogServer = jsonObject.getString("server");
            sLogcatSeconds = jsonObject.getInt("seconds");
            sValidLogParams = checkValid();
        } catch (JSONException e) {
            e.printStackTrace();
            sValidLogParams = false;
        }
    }

    public static boolean shouldLogcat(int what, int extra) {
        if (!sValidLogParams) {
            return false;
        }
        long now = System.currentTimeMillis() / 1000;
        if (now < sStartLogTimestamp || now > sEndLogTimestamp) {
            return false;
        }
        int todayTimes = SPUtil.getLogTimesOfToday();
        if (todayTimes >= 0) {
            sTodayTimes = todayTimes;
        } else {
            return false;
        }
        if (sTodayTimes >= sLogTimesDaily) {
            return false;
        }
        boolean validEvent = false;
        for (Pair<Integer, Integer> pair : sTriggerEvents) {
            if (pair.first == what && pair.second == extra) {
                validEvent = true;
                break;
            }
        }
        return validEvent;
    }

    public static void increaseLogTimes() {
        SPUtil.setLogTimesOfToday(++sTodayTimes);
    }

    public static int getTodayTimes() {
        return sTodayTimes;
    }

    public static int getLogcatSeconds() {
        return sLogcatSeconds;
    }

    private static void parseTriggerEvents(String trigger) {
        if (TextUtils.isEmpty(trigger)) {
            return;
        }
        String[] events = trigger.split(";");
        if (events.length == 0) {
            return;
        }
        for (String event : events) {
            String[] params = event.split(",");
            if (params.length != 2) {
                continue;
            }
            int first = CommonUtil.parseInt(params[0], 0);
            int second = CommonUtil.parseInt(params[1], 0);
            if (first == 0 || second == 0) {
                continue;
            }
            sTriggerEvents.add(new Pair<>(first, second));
        }
    }

    private static boolean checkValid() {
        if (!sEnable) {
            LogUtil.i(TAG, "logcat is disable");
            return false;
        }
        if (sStartLogTimestamp >= sEndLogTimestamp) {
            LogUtil.w(TAG, "invalid log timestamp");
            return false;
        }
        if (sLogTimesDaily < 1 || sLogTimesDaily > 100) {
            LogUtil.w(TAG, "invalid log times daily");
            return false;
        }
        if (sSingleLogSizeMB < 1 || sSingleLogSizeMB > 5) {
            LogUtil.w(TAG, "invalid log size");
            return false;
        }
        if (sTriggerEvents.isEmpty()) {
            LogUtil.w(TAG, "invalid log trigger events");
            return false;
        }
        if (TextUtils.isEmpty(sLogServer)) {
            LogUtil.w(TAG, "invalid log server");
            return false;
        }
        if (sLogcatSeconds <= 0) {
            LogUtil.w(TAG, "invalid log log seconds");
            return false;
        }
        LogUtil.w(TAG, "invalid log params");
        return true;
    }
}
