package com.ott.stream.rapid.agent.player;

import android.content.Context;
import android.os.Build;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ott.stream.rapid.agent.RapidAgentCall;
import com.ott.stream.rapid.agent.RapidAgentSource;
import com.ott.stream.rapid.agent.RapidAgentUri;
import com.ott.stream.rapid.agent.utils.LogUtil;
import com.ott.stream.rapid.player.PlayerBuilder;
import com.ott.stream.rapid.player.PlayerStatistic;
import com.ott.stream.rapid.player.RapidMediaPlayer;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import tv.danmaku.ijk.media.player.IMediaPlayer;

public class RapidAgentScalablePlayer extends RapidMediaPlayer implements RapidAgentPlayer {
    private static final String TAG = "RapidAgentScalablePlayer";

    private final SegmentDownloadedListener segmentDownloadedListener;

    public RapidAgentScalablePlayer(@Nullable Context context, int playerType, Map<String, String> params,
                                    PlayerStatistic playerStatistic, PlayerBuilder playerBuilder) {
        super(context, playerType, params, playerStatistic, playerBuilder);
        if (playerBuilder instanceof RapidPlayerBuilder) {
            segmentDownloadedListener = ((RapidPlayerBuilder) playerBuilder).getSegmentDownloadedListener();
        } else {
            segmentDownloadedListener = null;
        }
    }

    public void setRapidAgentUri(@NonNull RapidAgentUri rapidAgentUri) {
        if (rapidAgentUri.getDrmType() == RapidAgentUri.DRM_TYPE_WIDEVINE) {
            boolean supportMultiSession = Build.VERSION.SDK_INT > Build.VERSION_CODES.M;
            String drmLicenseUri = rapidAgentUri.getDrmLicenseUrl();
            Map<String, String> headers = new HashMap<>();
            if (rapidAgentUri.getDrmHeaders() != null) {
                headers.putAll(rapidAgentUri.getDrmHeaders());
            }
            setDrmInfo(IMediaPlayer.DRM_TYPE_WIDEVINE, supportMultiSession, drmLicenseUri, headers, rapidAgentUri.getDrmMethod(),
                    rapidAgentUri.getDrmOfflineLicenseKeySetId(), rapidAgentUri.getDrmOfflineLicenseInitInfo());
        }
    }

    public void setRapidAgentSource(@NonNull RapidAgentSource rapidAgentSource) {
        if (rapidAgentSource.getDrmType() == RapidAgentSource.DRM_TYPE_WIDEVINE) {
            boolean supportMultiSession = Build.VERSION.SDK_INT > Build.VERSION_CODES.M;
            String drmLicenseUri = rapidAgentSource.getDrmLicenseUrl();
            Map<String, String> headers = new HashMap<>();
            if (rapidAgentSource.getDrmHeaders() != null) {
                headers.putAll(rapidAgentSource.getDrmHeaders());
            }
            setDrmInfo(IMediaPlayer.DRM_TYPE_WIDEVINE, supportMultiSession, drmLicenseUri, headers, rapidAgentSource.getDrmMethod(),
                    rapidAgentSource.getDrmOfflineLicenseKeySetId(), rapidAgentSource.getDrmOfflineLicenseInitInfo());
        }
        try {
            setDataSource(rapidAgentSource.getPath());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setOnStreamMetricListener(OnStreamMetricListener listener) {
        LogUtil.e(TAG, "should not call setOnStreamMetricListener");
    }

    @Override
    public void setOnStreamStateListener(OnStreamStateListener listener) {
        LogUtil.e(TAG, "should not call setOnStreamStateListener");
    }

    @Override
    public void setOnCallStateChangedListener(RapidAgentCall.OnStateChangedListener stateChangedListener) {
        LogUtil.e(TAG, "should not call setOnCallStateChangedListener");
    }

    @Override
    public void updateTokens(String newUserToken, String newStreamToken) throws IOException {
        LogUtil.e(TAG, "should not call updateTokens");
    }

    @Override
    public void sendFrontLog(String msg) {
        LogUtil.e(TAG, "should not call sendFrontLog");
    }

    @NonNull
    @Override
    public Map<String, Object> getPlayMetric() {
        return Collections.emptyMap();
    }

    @Override
    public void onSegmentDownloaded(String params) {
        if (segmentDownloadedListener != null) {
            segmentDownloadedListener.onSegmentDownloaded(params);
        }
    }
}
