package com.ott.stream.rapid.agent.player;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;

import com.ott.stream.rapid.agent.utils.LogUtil;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ts.DefaultTsPayloadReaderFactory;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.hls.DefaultHlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSource;

import tv.danmaku.ijk.media.exo.IjkExoMediaPlayer;

public class RapidExoMediaPlayer extends IjkExoMediaPlayer {
    private static final String TAG = "RapidExoMediaPlayer";

    private final String urlSuffix;
    private final RapidExoBandwidthMeter bandwidthMeter;

    public RapidExoMediaPlayer(Context context, String urlSuffix) {
        super(context);
        this.urlSuffix = urlSuffix;
        this.bandwidthMeter = new RapidExoBandwidthMeter();
    }

    private final Object lock = new Object();

    @Override
    protected ExoPlayer createExoPlayer(Context context, TrackSelector trackSelector, BandwidthMeter bandwidthMeter) {
        DataSource.Factory dataSourceFactory;
        MediaSource.Factory mediaSourceFactory;
        dataSourceFactory = new DefaultDataSource.Factory(context);
        if (urlSuffix != null && urlSuffix.endsWith(".m3u8")) {
            DefaultHlsExtractorFactory hlsExtractorFactory = new DefaultHlsExtractorFactory(DefaultTsPayloadReaderFactory.FLAG_DETECT_ACCESS_UNITS, true);
            mediaSourceFactory = new HlsMediaSource.Factory(dataSourceFactory).setExtractorFactory(hlsExtractorFactory);
        } else {
            DefaultExtractorsFactory extractorsFactory = new DefaultExtractorsFactory();
            extractorsFactory.setTsExtractorFlags(DefaultTsPayloadReaderFactory.FLAG_DETECT_ACCESS_UNITS);
            mediaSourceFactory = new DefaultMediaSourceFactory(dataSourceFactory, extractorsFactory);
        }
        ExoPlayer.Builder builder = new ExoPlayer.Builder(context, mediaSourceFactory);
        if (trackSelector != null) {
            builder.setTrackSelector(trackSelector);
        }
        if (this.bandwidthMeter != null) {
            builder.setBandwidthMeter(this.bandwidthMeter);
        }
        return builder.build();
    }

    @Override
    public void release() {
        LogUtil.i(TAG, "release start");
        super.release();
        ExoPlayer exoPlayer = getInnerPlayer();
        Looper exoLooper = null;
        Thread exoThread = null;
        if (exoPlayer != null) {
            exoLooper = exoPlayer.getPlaybackLooper();
            exoThread = exoLooper.getThread();
        }
        if (exoLooper != null && exoThread.isAlive() && exoThread != Thread.currentThread()) {
            Handler handler = new Handler(getInnerPlayer().getApplicationLooper());
            handler.post(() -> {
                synchronized (lock) {
                    lock.notifyAll();
                }
            });
            synchronized (lock) {
                try {
                    LogUtil.i(TAG, "release waiting");
                    lock.wait(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        LogUtil.i(TAG, "release end");
    }

    public RapidExoBandwidthMeter getBandwidthMeter() {
        return bandwidthMeter;
    }
}
