package com.ott.stream.rapid.agent.player;

import com.ott.stream.rapid.agent.RapidAgentSource;
import com.ott.stream.rapid.agent.RapidAgentUri;
import com.ott.stream.rapid.player.PlayerBuilder;

public interface RapidPlayerBuilderCallback {
    RapidPlayerBuilder createPlayerBuilder(RapidAgentUri rapidAgentUri);

    PlayerBuilder createPlayerBuilder(RapidAgentSource rapidAgentSource);

    RapidPlayerBuilderCallback DEFAULT = new RapidPlayerBuilderCallback() {
        @Override
        public RapidPlayerBuilder createPlayerBuilder(RapidAgentUri rapidAgentUri) {
            return new RapidPlayerBuilderImpl(rapidAgentUri);
        }

        @Override
        public PlayerBuilder createPlayerBuilder(RapidAgentSource rapidAgentSource) {
            return new RapidAgentOpenBuilder(rapidAgentSource);
        }
    };
}
