package com.ott.stream.rapid.agent.prt;

import androidx.annotation.NonNull;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class StreamInfoMgr {
    public static final int INVALID = -1;
    public static final int LIVE = 0;
    public static final int CATCHUP = 1;
    public static final int VOD = 2;
    public static final int MB_ULTRA_LOW = 3;
    public static final int MB_LOW = 4;
    public static final int MB_NORMAL = 5;
    public static final int MB_GOP3 = 6;

    public static class StreamInfo {
        public int channelId;
        public int type;
        public String streamId;
        public long startupTime;
        public long engineReadyTime;
        public long playerStartupTime;
        public long playerReadyTime;

        public StreamInfo(int channelId, int type, String streamId, long startupTime) {
            this.channelId = channelId;
            this.type = type;
            this.streamId = streamId;
            this.startupTime = startupTime;
        }

        public boolean isLive() {
            return type == LIVE || isMicroBlock();
        }

        public boolean isVod() {
            return type == CATCHUP || type == VOD;
        }

        public boolean isMicroBlock() {
            return type == MB_ULTRA_LOW || type == MB_LOW || type == MB_NORMAL || type == MB_GOP3;
        }
    }

    private static final int MAX_QUEUE_SIZE = 10;

    private static final ConcurrentLinkedQueue<StreamInfo> STREAM_INFO_QUEUE = new ConcurrentLinkedQueue<>();

    public static void add(int channelId, int type, String streamId, long startupTime) {
        if (STREAM_INFO_QUEUE.size() >= MAX_QUEUE_SIZE) {
            STREAM_INFO_QUEUE.remove();
        }
        Iterator<StreamInfo> iterator = STREAM_INFO_QUEUE.iterator();
        while (iterator.hasNext()) {
            StreamInfo current = iterator.next();
            if (current.channelId == channelId) {
                iterator.remove();
            }
        }
        STREAM_INFO_QUEUE.add(new StreamInfo(channelId, type, streamId, startupTime));
    }

    @NonNull
    public static StreamInfo getStreamInfo(int channelId) {
        for (StreamInfo item : STREAM_INFO_QUEUE) {
            if (item.channelId == channelId) {
                return item;
            }
        }
        return new StreamInfo(channelId, INVALID, "", 0);
    }

    public static boolean checkStreamInfoByHashCode(int hashCode) {
        for (StreamInfo item : STREAM_INFO_QUEUE) {
            if (item.hashCode() == hashCode) {
                return true;
            }
        }
        return false;
    }
}
