package com.ott.stream.rapid.pct;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class SPUtil {
    private static final String FILE_NAME = "RapidAgentSDK";
    private static final String PCT_LOG_SERVER = "pct_log_server";

    private static SharedPreferences sSharedPreferences;

    public static void init(@Nullable Context context) {
        if (context == null) {
            Log.w("SPUtil", "Invalid Context Warning : init");
            return;
        }
        if (sSharedPreferences != null) {
            return;
        }
        sSharedPreferences = context.getSharedPreferences(FILE_NAME, Activity.MODE_PRIVATE);
    }

    @NonNull
    public static String getPCTLogServer(@NonNull String dflValue) {
        if (sSharedPreferences == null) {
            Log.w("SPUtil", "Invalid Context Warning : getPCTLogServer");
            return dflValue;
        }
        String host = sSharedPreferences.getString(PCT_LOG_SERVER, dflValue);
        if (host == null || host.isEmpty()) {
            return dflValue;
        }

        return host;
    }

    public static void setPCTLogServer(@NonNull String logServer) {
        if (sSharedPreferences == null) {
            Log.w("SPUtil", "Invalid Context Warning : setPCTLogServer");
            return;
        }
        SharedPreferences.Editor editor = sSharedPreferences.edit();
        editor.putString(PCT_LOG_SERVER, logServer);
        editor.apply();
    }
}
