package com.ott.stream.rapid.player;

import android.content.Context;
import android.util.Pair;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.Map;

import tv.danmaku.ijk.media.player.IMediaPlayer;

public interface PlayerBuilder {
    String DRM = "drm";
    String ABR = "abr";
    String MLS = "mls";

    void setDefaultPlayerType(int playerType);

    Pair<IMediaPlayer, Integer> createMediaPlayer(@Nullable Context context);

    Pair<IMediaPlayer, Integer> createMediaPlayer(@Nullable Context context, Map<String, String> params);

    Pair<IMediaPlayer, Integer> createMediaPlayer(@Nullable Context context, int playerType);

    IMediaPlayer createIjkMediaPlayer();

    IMediaPlayer createExoMediaPlayer(@NonNull Context context);

    IMediaPlayer createAndroidMediaPlayer();
}
