package com.ott.stream.rapid.player;

import android.net.Uri;

import androidx.annotation.NonNull;

import org.json.JSONObject;

import java.util.Map;

public interface PlayerStatistic {
    void setPlayerType(int playerType, int playerHash);

    void setDataSource(Uri uri);

    void prepareAsync();

    void start();

    void stopStart();

    void stopFinished();

    void pause();

    void seekTo(long msec);

    void releaseStart();

    void releaseFinished();

    void reset();

    void onError(int what, int extra);

    void onInfo(int what, int extra, String info);

    void onCompletion();

    void onStatusChanged(@NonNull Map<String, String> params);

    void onSeekComplete();

    void startupPerformance(JSONObject jsonObject);

    void bufferingPerformance(int extra, long duration, String startReason, String endReason);

    void seekPerformance(long duration);

    void releasePerformance(long stopDuration, long releaseDuration, long lifecycleDuration);

    void downloadPerformance(@NonNull Map<String, Object> params);
}
