package com.ott.stream.rapid.player.egl;

import android.view.Surface;

import androidx.annotation.NonNull;

public class DummyRenderer implements Renderer {
    private OnStateChangedListener stateChangedListener;
    private Surface inputSurface;

    public void surfaceCreated(@NonNull Surface surface) {
        this.inputSurface = surface;
        if (stateChangedListener != null) {
            stateChangedListener.onPrepared();
        }
    }

    public void surfaceChanged(int width, int height) {

    }

    public void surfaceDestroyed() {
        if (stateChangedListener != null) {
            stateChangedListener.onReleased();
        }
    }

    @Override
    public void setStateChangedListener(OnStateChangedListener listener) {
        this.stateChangedListener = listener;
    }

    @Override
    public void setOutputSurface(Surface surface) {

    }

    @Override
    public void requestRender(MapsTexture pipeline) {

    }

    @Override
    public Surface createInputSurface() {
        return inputSurface;
    }

    @Override
    public void releaseInputSurface(Surface surface) {

    }

    @Override
    public void disableInputSurface(Surface surface) {

    }
}
