package com.ott.stream.rapid.player.egl;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

import androidx.annotation.NonNull;

import com.ott.stream.rapid.player.R;

public class RapidSurfaceView extends SurfaceView {
    private static int sDefaultRendererType = 0;
    private static int sDefaultMaxTextureCount = 2;
    private int rendererType = 0;
    private int maxTextures = 0;
    private Renderer renderer;

    public RapidSurfaceView(Context context) {
        super(context);
        init();
    }

    public RapidSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RapidSurfaceView);
        rendererType = typedArray.getInt(R.styleable.RapidSurfaceView_rapid_renderer_type, rendererType);
        maxTextures = typedArray.getInt(R.styleable.RapidSurfaceView_rapid_max_textures, maxTextures);
        typedArray.recycle();
        init();
    }

    public RapidSurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RapidSurfaceView, defStyleAttr, 0);
        rendererType = typedArray.getInt(R.styleable.RapidSurfaceView_rapid_renderer_type, rendererType);
        maxTextures = typedArray.getInt(R.styleable.RapidSurfaceView_rapid_max_textures, maxTextures);
        typedArray.recycle();
        init();
    }

    public static void seDefaultRendererType(int rendererType) {
        sDefaultRendererType = rendererType;
    }

    public static void setDefaultMaxTextureCount(int count) {
        sDefaultMaxTextureCount = count;
    }

    private void init() {
        if (rendererType == 0) {
            rendererType = sDefaultRendererType;
        }
        if (maxTextures == 0) {
            maxTextures = sDefaultMaxTextureCount;
        }
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.N) {
            // B9 AMP播放个别频道时，画面显示竖条
            Log.i("RapidSurfaceView", "only support devices that api level is 24 or above");
            rendererType = 0;
        }
        if (rendererType == 1) {
            renderer = new SingleTextureRenderer();
        } else if (rendererType == 2) {
            renderer = new MultiTextureRenderer(maxTextures);
        } else {
            renderer = new DummyRenderer();
        }
        Log.d("RapidSurfaceView", "init renderer " + renderer);
        getHolder().addCallback(new SurfaceHolder.Callback() {
            @Override
            public void surfaceCreated(@NonNull SurfaceHolder holder) {
                renderer.surfaceCreated(holder.getSurface());
            }

            @Override
            public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
                renderer.surfaceChanged(width, height);
            }

            @Override
            public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
                renderer.surfaceDestroyed();
            }
        });
    }

    public void setStateChangedListener(OnStateChangedListener listener) {
        renderer.setStateChangedListener(listener);
    }

    public Surface createInputSurface() {
        return renderer.createInputSurface();
    }

    public void releaseInputSurface(Surface surface) {
        renderer.releaseInputSurface(surface);
    }

    public void disableInputSurface(Surface surface) {
        renderer.disableInputSurface(surface);
    }
}
