package com.ott.stream.rapid.player.egl;

import android.opengl.GLES20;
import android.view.Surface;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class SingleTextureRenderer extends AbsTextureRenderer implements MapsTexture.OnFrameAvailableListener {
    private final AtomicReference<MapsTexture> textureRef = new AtomicReference<>(null);
    private final Object textureLock = new Object();

    @Override
    public void surfaceDestroyed() {
        releaseInputSurface(null);
        super.surfaceDestroyed();
    }

    @Override
    public Surface createInputSurface() {
        final MapsTexture texture = textureRef.get();
        if (texture != null) {
            texture.setOnFrameAvailableListener(null);
        }
        textureRef.set(null);
        AtomicBoolean isWaiting = new AtomicBoolean();
        runOnEglThread(() -> {
            if (texture != null) {
                texture.release();
            }
            MapsTexture newTexture = new MapsTexture();
            newTexture.init(GLES20.GL_TEXTURE0);
            newTexture.setOnFrameAvailableListener(SingleTextureRenderer.this);
            textureRef.set(newTexture);
            if (isWaiting.get()) {
                synchronized (textureLock) {
                    textureLock.notifyAll();
                }
            }
        });
        if (textureRef.get() == null) {
            synchronized (textureLock) {
                try {
                    isWaiting.set(true);
                    textureLock.wait();
                    isWaiting.set(false);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        return textureRef.get().getSurface();
    }

    @Override
    public void releaseInputSurface(Surface surface) {
        MapsTexture texture = textureRef.get();
        if (texture != null) {
            runOnEglThread(texture::release);
            texture.setOnFrameAvailableListener(null);
            textureRef.set(null);
        }
    }

    @Override
    public void disableInputSurface(Surface surface) {
        MapsTexture texture = textureRef.get();
        if (texture != null) {
            texture.setOnFrameAvailableListener(null);
        }
    }

    @Override
    public void onFrameAvailable(MapsTexture pipeline) {
        requestRender(pipeline);
    }
}
