package com.ott.trans.jni;

import com.ott.trans.JniPrtListener;

import java.util.Map;

public class J2NMain {
    public native int init(String transPath, String transCfg, Map<String, String> map);

    public native int destroy();

    public native int playLiveCall(String sysParams, String callParams, JniPrtListener listener, Map<String, String> map);

    public native int playVodCall(String callParams, String index);

    public native int requestCall(int callId, long offset);

    public native int requestCallByName(int callId, String name);

    public native int requestCallFromName(int callId, String name);

    public native int requestCallFromId(int callId, int id);

    public native String getCallM3u8(String callHash);

    public native String getMPQM3u8();

    public native int setCallState(String callHash, int downState, int cacheState);

    public native String getLocalCalls();

    public native int stopCall(int callId);

    public native int setCallParams(String cfg, Object value);

    public native int setNetworkMode(int state, String localIp);

    public native int setCallMask(int mask);

    public native void setUpnpIpList(int callId, String ipList);

    public native void enableLog(boolean enable, int period); // period : ms

    public native int clearLog();

    public native int getRsRand();

    public native String getStringVersion();

    public native byte[] encryptByPriKey(byte[] input, byte[] key);

    public native byte[] decryptByPriKey(byte[] input, byte[] key);

    public native byte[] encryptByPubKey(byte[] input, byte[] key);

    public native byte[] decryptByPubKey(byte[] input, byte[] key);

    public native void notifyPlayerBuffering(int callId, int times, int ms);

    public native void updateCall(int var1, String var2);

    public native boolean isBlockDownloaded(int callId, int blockId);

    public native void sendAppLog(int callId, String log);

    public native int getHttpProxyPort(int port);

    public native void initHttpProxyBuffer(int callId, int bkLen, long totalLen, int soluType, int soluBrand, String drmLink, String drmKey, int useIdMap, int pushMode, int isAbr);

    public native void closeHttpProxyBuffer(int callId);

    public native void setBlockAesKey(int callId, String key);

    public native int getDownloadSpeed(int callId);

    public native int requestVodCallInfo(String callParams, String index);

//    public native int seekTimeShiftData(int callId, long delay);

    public native void setAppRunMode(int mode);
}
