package com.ott.trans.jni;

import com.ott.trans.JniPrtListener;
import com.ott.trans.PrtListenerManager;

import java.util.Map;

/* JNI静态反式调用 */
public class N2JMain {
    private static final String TAG = "N2JMain";

    public static final int EVENT_VOD_DOWNLOAD_PROGRESS = 0x2001;
    public static final int EVENT_VOD_CACHE_REACH_MAX_SIZE = 0x2002;
    public static final int EVENT_VOD_DEVICE_DISK_INSUFFICIENT = 0x2003;

    public static final int DEFAULT_REQUEST_ID = 8383;

    //直播收到数据
    public static int onDataRecv(int callId, int bkId, byte[] data) {
//        LogUtils.d(TAG, "onDataRecv callId:%d requestId:%d bkId:%d dataLen:%d:", callId, bkId, data.length);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(callId, DEFAULT_REQUEST_ID);
//        LogUtils.d(TAG, "onDataRecv listener:" + listener);
        if (listener != null) {
            return listener.onDataAvail(callId, bkId, data);
        } else {
            return data.length;
        }
    }

    //直播收到数据
    public static int onDataRecv(int callId, int bkId, byte[] data, int offset, int len) {
//        LogUtils.d(TAG, "onDataRecv callId:%d bkId:%d offset:%d dataLen:%d:", callId, bkId, offset, data.length);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(callId, DEFAULT_REQUEST_ID);
//        LogUtils.d(TAG, "onDataRecv listener:" + listener);
        if (listener != null) {
            return listener.onDataAvail(callId, bkId, data, offset, len);
        } else {
            return data.length;
        }
    }

    //直播收到数据
    public static int onDataRecv(int callId, int bkId, byte[] data, int offset, int len, long timeout) {
//        LogUtils.d(TAG, "onDataRecv callId:%d bkId:%d offset:%d dataLen:%d:", callId, bkId, offset, data.length);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(callId, DEFAULT_REQUEST_ID);
//        LogUtils.d(TAG, "onDataRecv listener:" + listener);
        if (listener != null) {
            return listener.onDataAvail(callId, bkId, data, offset, len, timeout);
        } else {
            return data.length;
        }
    }

    //点播收到数据
    public static int onDataRecv(int callId, int bkId, byte[] data, long offset, int requestId, int waitMs) {
//        LogUtils.d(TAG, "onDataRecv callId:%d requestId:%d bkId:%d offset:%d dataLen:%d:", callId, requestId, bkId, offset, data.length);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(callId, requestId);
//        LogUtils.d(TAG, "onDataRecv listener:" + listener);
        if (listener != null) {
            return listener.onDataAvail(callId, requestId, bkId, data, offset, waitMs);
        } else {
            return data.length;
        }
    }

    public static int onDataRecv(int callId, int bkId, byte[] data, int offsetInBlock, int offsetInFile, int len, long timeout) {
//        LogUtils.d(TAG, "onDataRecv, callId:%d bkId:%d offsetInBlock:%d offsetInFile:%d len:%d timeout:%d", callId, bkId, offsetInBlock, offsetInFile, len, timeout);
        return 0;
    }

    //点播
    public static int onCheckDataRecvBuffer(int callId, int bkId, int len, long offset, int requestId) {
        int avail = 0;
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(callId, requestId);
        if (listener != null) {
            avail = listener.onCheckRecvDataBuffer(requestId, bkId, len, offset);
        }
//        LogUtils.d(TAG, "onCheckRecvDataBuffer callId:%d requestId:%d bkId:%d offset:%d len:%d avail:%d", callId, requestId, bkId, offset, len, avail);
        return avail;
    }

    public static int onOttMetric(int callId, Map<String, String> var2) {
//        LogUtils.d(TAG, "onMetric 2, callId:%d", callId);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(callId, DEFAULT_REQUEST_ID);
        if (listener != null) {
            return listener.onMetric(callId, var2);
        }
        return 0;
    }

    public static int onOttState(int callId, Map<String, String> var2) {
//        LogUtils.d(TAG, "onState, callId:%d", callId);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(callId, DEFAULT_REQUEST_ID);
        if (listener != null) {
            return listener.onState(callId, var2);
        }
        return 0;
    }

    public static void onRequestNat(int callId, String var2, int var3) {
//        LogUtils.d(TAG, "onRequestNat, callId:%d", callId);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(callId, DEFAULT_REQUEST_ID);
        if (listener != null) {
            listener.onNatReq(callId, var2, var3);
        }
    }

    public static void onOttEvent(int callId, int var2, String var3, String var4) {
//        LogUtils.d(TAG, "onEvent, callId:%d", callId);
        if (var2 == EVENT_VOD_DOWNLOAD_PROGRESS || var2 == EVENT_VOD_DEVICE_DISK_INSUFFICIENT) {
            PrtListenerManager.PrtCacheEventListener prtCacheEventListener = PrtListenerManager.getInstance().getPrtCacheEventListener();
            if (prtCacheEventListener != null) {
                prtCacheEventListener.onCacheEvent(callId, var2, var3, var4);
            }
        } else {
            JniPrtListener listener = PrtListenerManager.getInstance().findListener(callId, DEFAULT_REQUEST_ID);
            if (listener != null) {
                listener.onEvent(callId, var2, var3, var4);
            }
        }
    }

    public static int getPlayerBufferedTime(int callId) {
//        LogUtils.d(TAG, "getPlayerBufferedTime, callId:%d", callId);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(callId, DEFAULT_REQUEST_ID);
        if (listener != null) {
            return listener.getPlayerCacheTime(callId);
        }
        return 0;
    }
}
