package com.ott.trans.utils;

import android.util.Log;

public class LogUtils {
    public static int VERBOSE = 5;
    public static int DEBUG = 4;
    public static int INFO = 3;
    public static int WARN = 2;
    public static int ERROR = 1;
    public static int SILENT = 0;

    public static int LOG_LEVEL = SILENT;

    public static void setLogLevel(int level) {
        LOG_LEVEL = level;
    }

    public static void v(String tag, String format, Object... args) {
        if (LOG_LEVEL >= VERBOSE) {
            String msg = String.format(format, args);
            Log.v(tag, msg);
        }
    }

    public static void d(String tag, String format, Object... args) {
        if (LOG_LEVEL >= DEBUG) {
            String msg = String.format(format, args);
            Log.d(tag, msg);
        }
    }

    public static void i(String tag, String format, Object... args) {
        if (LOG_LEVEL >= INFO) {
            String msg = String.format(format, args);
            Log.i(tag, msg);
        }
    }

    public static void w(String tag, String format, Object... args) {
        if (LOG_LEVEL >= WARN) {
            String msg = String.format(format, args);
            Log.w(tag, msg);
        }
    }

    public static void e(String tag, String format, Object... args) {
        if (LOG_LEVEL >= ERROR) {
            String msg = String.format(format, args);
            Log.e(tag, msg);
        }
    }
}
