/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.modifier;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;

@StatelessCheck
public class RedundantModifierCheck
extends AbstractCheck {
    public static final String MSG_KEY = "redundantModifier";
    private static final int[] TOKENS_FOR_INTERFACE_MODIFIERS = new int[]{64, 40};

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 10, 161, 15, 8, 14, 154, 178};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 15) {
            this.checkInterfaceModifiers(ast);
        } else if (ast.getType() == 154) {
            this.checkEnumDef(ast);
        } else {
            if (ast.getType() == 8) {
                if (RedundantModifierCheck.isEnumMember(ast)) {
                    this.checkEnumConstructorModifiers(ast);
                } else {
                    this.checkClassConstructorModifiers(ast);
                }
            } else if (ast.getType() == 9) {
                this.processMethods(ast);
            } else if (ast.getType() == 178) {
                this.processResources(ast);
            }
            if (RedundantModifierCheck.isInterfaceOrAnnotationMember(ast)) {
                this.processInterfaceOrAnnotation(ast);
            }
        }
    }

    private void checkInterfaceModifiers(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        for (int tokenType : TOKENS_FOR_INTERFACE_MODIFIERS) {
            DetailAST modifier = modifiers.findFirstToken(tokenType);
            if (modifier == null) continue;
            this.log(modifier.getLineNo(), modifier.getColumnNo(), MSG_KEY, modifier.getText());
        }
    }

    private void checkEnumConstructorModifiers(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        DetailAST modifier = RedundantModifierCheck.getFirstModifierAst(modifiers);
        if (modifier != null) {
            this.log(modifier.getLineNo(), modifier.getColumnNo(), MSG_KEY, modifier.getText());
        }
    }

    private static DetailAST getFirstModifierAst(DetailAST modifiers) {
        DetailAST modifier;
        for (modifier = modifiers.getFirstChild(); modifier != null && modifier.getType() == 159; modifier = modifier.getNextSibling()) {
        }
        return modifier;
    }

    private void checkEnumDef(DetailAST ast) {
        if (RedundantModifierCheck.isInterfaceOrAnnotationMember(ast)) {
            this.processInterfaceOrAnnotation(ast);
        } else if (ast.getParent() != null) {
            this.checkForRedundantModifier(ast, 64);
        }
    }

    private void processInterfaceOrAnnotation(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            int type = modifier.getType();
            if (!(type == 62 || type == 64 && ast.getType() != 9 || type == 40 && ast.getType() != 14) && (type != 39 || ast.getType() == 14)) continue;
            this.log(modifier.getLineNo(), modifier.getColumnNo(), MSG_KEY, modifier.getText());
            break;
        }
    }

    private void processMethods(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        boolean checkFinal = modifiers.findFirstToken(61) != null;
        DetailAST parent = ast.getParent();
        while (parent != null && !checkFinal) {
            if (parent.getType() == 14) {
                DetailAST classModifiers = parent.findFirstToken(5);
                checkFinal = classModifiers.findFirstToken(39) != null;
                parent = null;
                continue;
            }
            if (parent.getType() == 136 || parent.getType() == 155) {
                checkFinal = true;
                parent = null;
                continue;
            }
            if (parent.getType() == 154) {
                checkFinal = modifiers.findFirstToken(64) != null;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        if (checkFinal && !RedundantModifierCheck.isAnnotatedWithSafeVarargs(ast)) {
            this.checkForRedundantModifier(ast, 39);
        }
        if (ast.findFirstToken(7) == null) {
            this.processAbstractMethodParameters(ast);
        }
    }

    private void processAbstractMethodParameters(DetailAST ast) {
        DetailAST parameters = ast.findFirstToken(20);
        for (DetailAST child = parameters.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 21) continue;
            this.checkForRedundantModifier(child, 39);
        }
    }

    private void checkClassConstructorModifiers(DetailAST classCtorAst) {
        DetailAST classDef = classCtorAst.getParent().getParent();
        if (!RedundantModifierCheck.isClassPublic(classDef) && !RedundantModifierCheck.isClassProtected(classDef)) {
            this.checkForRedundantModifier(classCtorAst, 62);
        }
    }

    private void processResources(DetailAST ast) {
        this.checkForRedundantModifier(ast, 39);
    }

    private void checkForRedundantModifier(DetailAST ast, int modifierType) {
        DetailAST astModifiers = ast.findFirstToken(5);
        for (DetailAST astModifier = astModifiers.getFirstChild(); astModifier != null; astModifier = astModifier.getNextSibling()) {
            if (astModifier.getType() != modifierType) continue;
            this.log(astModifier.getLineNo(), astModifier.getColumnNo(), MSG_KEY, astModifier.getText());
        }
    }

    private static boolean isClassProtected(DetailAST classDef) {
        DetailAST classModifiers = classDef.findFirstToken(5);
        return classModifiers.findFirstToken(63) != null;
    }

    private static boolean isClassPublic(DetailAST ast) {
        boolean hasPublicModifier;
        boolean isAccessibleFromPublic = false;
        boolean isMostOuterScope = ast.getParent() == null;
        DetailAST modifiersAst = ast.findFirstToken(5);
        boolean bl = hasPublicModifier = modifiersAst.findFirstToken(62) != null;
        if (isMostOuterScope) {
            isAccessibleFromPublic = hasPublicModifier;
        } else {
            DetailAST parentClassAst = ast.getParent().getParent();
            if (hasPublicModifier || parentClassAst.getType() == 15) {
                isAccessibleFromPublic = RedundantModifierCheck.isClassPublic(parentClassAst);
            }
        }
        return isAccessibleFromPublic;
    }

    private static boolean isEnumMember(DetailAST ast) {
        DetailAST parentTypeDef = ast.getParent().getParent();
        return parentTypeDef.getType() == 154;
    }

    private static boolean isInterfaceOrAnnotationMember(DetailAST ast) {
        DetailAST parentTypeDef = ast.getParent();
        if (parentTypeDef != null) {
            parentTypeDef = parentTypeDef.getParent();
        }
        return parentTypeDef != null && (parentTypeDef.getType() == 15 || parentTypeDef.getType() == 157);
    }

    private static boolean isAnnotatedWithSafeVarargs(DetailAST methodDef) {
        boolean result = false;
        List<DetailAST> methodAnnotationsList = RedundantModifierCheck.getMethodAnnotationsList(methodDef);
        for (DetailAST annotationNode : methodAnnotationsList) {
            if (!"SafeVarargs".equals(annotationNode.getLastChild().getText())) continue;
            result = true;
            break;
        }
        return result;
    }

    private static List<DetailAST> getMethodAnnotationsList(DetailAST methodDef) {
        ArrayList<DetailAST> annotationsList = new ArrayList<DetailAST>();
        DetailAST modifiers = methodDef.findFirstToken(5);
        for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            if (modifier.getType() != 159) continue;
            annotationsList.add(modifier);
        }
        return annotationsList;
    }
}

