/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public final class FilterUtils {
    private FilterUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileExists(String fileName) {
        boolean suppressionSourceExists = true;
        InputStream sourceInput = null;
        try {
            URI uriByFilename = CommonUtils.getUriByFilename(fileName);
            URL url = uriByFilename.toURL();
            sourceInput = url.openStream();
            suppressionSourceExists = FilterUtils.closeQuietlyWithResult(sourceInput, suppressionSourceExists);
        }
        catch (CheckstyleException | IOException ignored) {
            suppressionSourceExists = false;
        }
        finally {
            suppressionSourceExists = FilterUtils.closeQuietlyWithResult(sourceInput, suppressionSourceExists);
        }
        return suppressionSourceExists;
    }

    private static boolean closeQuietlyWithResult(InputStream sourceInput, boolean suppressionSourceExists) {
        boolean closed = suppressionSourceExists;
        if (sourceInput != null) {
            try {
                sourceInput.close();
            }
            catch (IOException ignored) {
                closed = false;
            }
        }
        return closed;
    }
}

