/*
 * Decompiled with CFR 0.152.
 */
package io.redisearch;

import io.redisearch.Document;
import java.util.ArrayList;
import java.util.List;

public class SearchResult {
    public final long totalResults;
    public final List<Document> docs;

    public SearchResult(List<Object> resp, boolean hasContent, boolean hasScores, boolean hasPayloads) {
        this(resp, hasContent, hasScores, hasPayloads, true);
    }

    public SearchResult(List<Object> resp, boolean hasContent, boolean hasScores, boolean hasPayloads, boolean decode) {
        int step = 1;
        int scoreOffset = 0;
        int contentOffset = 1;
        int payloadOffset = 0;
        if (hasScores) {
            ++step;
            scoreOffset = 1;
            ++contentOffset;
        }
        if (hasContent) {
            ++step;
            if (hasPayloads) {
                payloadOffset = scoreOffset + 1;
                ++step;
                ++contentOffset;
            }
        }
        this.totalResults = (Long)resp.get(0);
        this.docs = new ArrayList<Document>(resp.size() - 1);
        for (int i = 1; i < resp.size(); i += step) {
            Double score = hasScores ? Double.valueOf(new String((byte[])resp.get(i + scoreOffset))) : 1.0;
            byte[] payload = hasPayloads ? (byte[])resp.get(i + payloadOffset) : null;
            List fields = hasContent ? (List)resp.get(i + contentOffset) : null;
            String id = new String((byte[])resp.get(i));
            this.docs.add(Document.load(id, score, payload, fields, decode));
        }
    }
}

