/*
 * Decompiled with CFR 0.152.
 */
package io.redisearch.aggregation;

import io.redisearch.aggregation.Group;
import io.redisearch.aggregation.Limit;
import io.redisearch.aggregation.SortedField;
import io.redisearch.aggregation.reducers.Reducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import redis.clients.jedis.util.SafeEncoder;

public class AggregationBuilder {
    private final List<String> args = new ArrayList<String>();
    private boolean isWithCursor = false;

    public AggregationBuilder(String query) {
        this.args.add(query);
    }

    public AggregationBuilder() {
        this("*");
    }

    public AggregationBuilder load(String ... fields) {
        AggregationBuilder.addCmdArgs(this.args, "LOAD", Arrays.asList(fields));
        return this;
    }

    public AggregationBuilder limit(int offset, int count) {
        Limit limit = new Limit(offset, count);
        limit.addArgs(this.args);
        return this;
    }

    public AggregationBuilder limit(int count) {
        return this.limit(0, count);
    }

    public AggregationBuilder sortBy(SortedField ... fields) {
        this.args.add("SORTBY");
        this.args.add(Integer.toString(fields.length * 2));
        for (SortedField field : fields) {
            this.args.add(field.getField());
            this.args.add(field.getOrder());
        }
        return this;
    }

    public AggregationBuilder sortBy(int max, SortedField ... fields) {
        this.sortBy(fields);
        if (max > 0) {
            this.args.add("MAX");
            this.args.add(Integer.toString(max));
        }
        return this;
    }

    public AggregationBuilder sortByAsc(String field) {
        return this.sortBy(SortedField.asc(field));
    }

    public AggregationBuilder sortByDesc(String field) {
        return this.sortBy(SortedField.desc(field));
    }

    public AggregationBuilder apply(String projection, String alias) {
        this.args.add("APPLY");
        this.args.add(projection);
        this.args.add("AS");
        this.args.add(alias);
        return this;
    }

    public AggregationBuilder groupBy(Collection<String> fields, Collection<Reducer> reducers) {
        String[] fieldsArr = new String[fields.size()];
        Group g = new Group(fields.toArray(fieldsArr));
        for (Reducer r : reducers) {
            g.reduce(r);
        }
        this.groupBy(g);
        return this;
    }

    public AggregationBuilder groupBy(String field, Reducer ... reducers) {
        return this.groupBy(Collections.singletonList(field), Arrays.asList(reducers));
    }

    public AggregationBuilder groupBy(Group group) {
        this.args.add("GROUPBY");
        group.addArgs(this.args);
        return this;
    }

    public AggregationBuilder filter(String expression) {
        this.args.add("FILTER");
        this.args.add(expression);
        return this;
    }

    public AggregationBuilder cursor(int count, long maxIdle) {
        this.isWithCursor = true;
        if (count > 0) {
            this.args.add("WITHCURSOR");
            this.args.add("COUNT");
            this.args.add(Integer.toString(count));
            if (maxIdle < Long.MAX_VALUE && maxIdle >= 0L) {
                this.args.add("MAXIDLE");
                this.args.add(Long.toString(maxIdle));
            }
        }
        return this;
    }

    private static void addCmdLen(List<String> list, String cmd, int len) {
        list.add(cmd);
        list.add(Integer.toString(len));
    }

    private static void addCmdArgs(List<String> dst, String cmd, List<String> src) {
        AggregationBuilder.addCmdLen(dst, cmd, src.size());
        dst.addAll(src);
    }

    public List<String> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public void serializeRedisArgs(List<byte[]> redisArgs) {
        for (String s : this.getArgs()) {
            redisArgs.add(SafeEncoder.encode((String)s));
        }
    }

    public String getArgsString() {
        StringJoiner sj = new StringJoiner(" ");
        for (String s : this.getArgs()) {
            sj.add(s);
        }
        return sj.toString();
    }

    public boolean isWithCursor() {
        return this.isWithCursor;
    }
}

