/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk;

import com.sensorsdata.analytics.javasdk.SensorsData;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SensorsAnalyticsWorker {
    private static final Logger log = LoggerFactory.getLogger(SensorsAnalyticsWorker.class);
    private final Consumer consumer;
    private final Map<String, Object> superProperties = new ConcurrentHashMap<String, Object>();
    private boolean enableTimeFree = false;

    public SensorsAnalyticsWorker(Consumer consumer) {
        this.consumer = consumer;
        this.clearSuperProperties();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                log.info("Triggered flush when the program is closed.");
                SensorsAnalyticsWorker.this.flush();
            }
        }));
    }

    void setEnableTimeFree(boolean enableTimeFree) {
        log.info("Call setEnableTimeFree method with param:{}", (Object)enableTimeFree);
        this.enableTimeFree = enableTimeFree;
    }

    void setSuperProperties(Map<String, Object> superProperties) {
        this.superProperties.putAll(superProperties);
    }

    void clearSuperProperties() {
        this.superProperties.clear();
        this.superProperties.put("$lib", "Java");
        this.superProperties.put("$lib_version", "3.4.3");
        log.info("Call clearSuperProperties method.");
    }

    void doAddEvent(String distinctId, boolean isLoginId, String originDistinctId, String actionType, String eventName, Map<String, Object> properties) {
        this.consumer.send(this.generateEventMap(distinctId, isLoginId, originDistinctId, null, actionType, eventName, properties));
    }

    void doAddData(@NonNull SensorsData sensorsData) {
        Map<String, Object> properties;
        if (sensorsData == null) {
            throw new NullPointerException("sensorsData is marked non-null but is null");
        }
        if (this.enableTimeFree) {
            sensorsData.getProperties().put("time_free", true);
        }
        if ((properties = sensorsData.getProperties()).containsKey("$project")) {
            sensorsData.setProject(properties.get("$project").toString());
            properties.remove("$project");
        }
        if (properties.containsKey("$token")) {
            sensorsData.setToken(properties.get("$token").toString());
            properties.remove("$token");
        }
        if (properties.containsKey("$time")) {
            sensorsData.setTime((Date)properties.get("$time"));
            properties.remove("$time");
        }
        if (this.superProperties.containsKey("$app_version")) {
            sensorsData.getLib().put("$app_version", (String)this.superProperties.get("$app_version"));
        }
        if (sensorsData.getType().startsWith("track")) {
            properties.putAll(this.superProperties);
        }
        this.consumer.send(SensorsData.generateData(sensorsData));
    }

    void doAddItem(String itemType, String itemId, String actionType, Map<String, Object> properties) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("item_type", itemType);
        item.put("item_id", itemId);
        item.put("type", actionType);
        item.put("time", System.currentTimeMillis());
        item.put("lib", this.getLibProperties());
        HashMap<String, Object> itemProperties = new HashMap<String, Object>();
        if (properties != null && !properties.isEmpty()) {
            block8: for (Map.Entry<String, Object> entry : properties.entrySet()) {
                switch (entry.getKey()) {
                    case "$project": {
                        item.put("project", entry.getValue());
                        continue block8;
                    }
                    case "$token": {
                        item.put("token", entry.getValue());
                        continue block8;
                    }
                }
                itemProperties.put(entry.getKey(), entry.getValue());
            }
        }
        item.put("properties", itemProperties);
        this.consumer.send(item);
    }

    void doAddEventIdentity(Map<String, String> identity, String actionType, String eventName, Map<String, Object> properties) {
        this.consumer.send(this.generateEventMap(null, null, null, identity, actionType, eventName, properties));
    }

    void flush() {
        this.consumer.flush();
    }

    void shutdown() {
        this.consumer.close();
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> generateEventMap(String distinctId, Boolean isLoginId, String originDistinctId, Map<String, String> identity, String actionType, String eventName, Map<String, Object> properties) {
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        eventMap.put("_track_id", new Random().nextInt());
        eventMap.put("type", actionType);
        eventMap.put("lib", this.getLibProperties());
        if (this.enableTimeFree) {
            eventMap.put("time_free", true);
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        if (identity == null) {
            eventMap.put("distinct_id", distinctId);
            if (isLoginId.booleanValue()) {
                eventProperties.put("$is_login_id", true);
            }
        } else {
            eventMap.put("identities", identity);
            if (distinctId != null) {
                eventMap.put("distinct_id", distinctId);
                eventProperties.put("$is_login_id", false);
            } else if (identity.containsKey("$identity_login_id")) {
                eventProperties.put("$is_login_id", true);
                eventMap.put("distinct_id", identity.get("$identity_login_id"));
            } else {
                eventProperties.put("$is_login_id", false);
                String firstKey = identity.keySet().iterator().next();
                eventMap.put("distinct_id", String.format("%s+%s", firstKey, identity.get(firstKey)));
            }
        }
        if (properties != null && !properties.isEmpty()) {
            block20: for (Map.Entry entry : properties.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "$time": {
                        eventMap.put("time", ((Date)entry.getValue()).getTime());
                        continue block20;
                    }
                    case "$project": {
                        eventMap.put("project", entry.getValue());
                        continue block20;
                    }
                    case "$token": {
                        eventMap.put("token", entry.getValue());
                        continue block20;
                    }
                }
                eventProperties.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (actionType != null) {
            void var11_17;
            String string = actionType;
            int n = -1;
            switch (string.hashCode()) {
                case -2023456116: {
                    if (!string.equals("track_signup")) break;
                    boolean bl = false;
                    break;
                }
                case 110621003: {
                    if (!string.equals("track")) break;
                    boolean bl = true;
                    break;
                }
                case 1261364717: {
                    if (!string.equals("track_id_bind")) break;
                    int n2 = 2;
                    break;
                }
                case 1538937862: {
                    if (!string.equals("track_id_unbind")) break;
                    int n3 = 3;
                }
            }
            switch (var11_17) {
                case 0: {
                    eventMap.put("original_id", originDistinctId);
                }
                case 1: 
                case 2: 
                case 3: {
                    eventMap.put("event", eventName);
                    eventProperties.putAll(this.superProperties);
                }
            }
        }
        if (!eventMap.containsKey("time")) {
            eventMap.put("time", System.currentTimeMillis());
        }
        eventMap.put("properties", eventProperties);
        return eventMap;
    }

    private Map<String, String> getLibProperties() {
        Map<String, String> libInfo = SensorsAnalyticsUtil.generateLibInfo();
        if (this.superProperties.containsKey("$app_version")) {
            libInfo.put("$app_version", (String)this.superProperties.get("$app_version"));
        }
        return libInfo;
    }
}

