/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.URLs;

import com.shapesecurity.salvation2.Constants;
import com.shapesecurity.salvation2.URLs.URLWithScheme;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;

public class GUID
extends URLWithScheme {
    public GUID(@Nonnull String scheme, @Nonnull String value) {
        super(scheme, null, null, value);
    }

    public static Optional<GUID> parseGUID(String value) {
        Matcher matcher = Constants.schemePattern.matcher(value);
        if (!matcher.find()) {
            return Optional.empty();
        }
        String scheme = matcher.group("scheme");
        scheme = scheme.substring(0, scheme.length() - 1);
        return Optional.of(new GUID(scheme, value.substring(scheme.length() + 1)));
    }
}

