/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.Moshi;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiRequestBodyConverter;
import retrofit2.converter.moshi.MoshiResponseBodyConverter;

public final class MoshiConverterFactory
extends Converter.Factory {
    private final Moshi moshi;
    private final boolean lenient;

    public static MoshiConverterFactory create() {
        return MoshiConverterFactory.create(new Moshi.Builder().build());
    }

    public static MoshiConverterFactory create(Moshi moshi) {
        return new MoshiConverterFactory(moshi, false);
    }

    private MoshiConverterFactory(Moshi moshi, boolean lenient) {
        if (moshi == null) {
            throw new NullPointerException("moshi == null");
        }
        this.moshi = moshi;
        this.lenient = lenient;
    }

    public MoshiConverterFactory asLenient() {
        return new MoshiConverterFactory(this.moshi, true);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JsonAdapter adapter = this.moshi.adapter(type, MoshiConverterFactory.jsonAnnotations(annotations));
        if (this.lenient) {
            adapter = adapter.lenient();
        }
        return new MoshiResponseBodyConverter(adapter);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JsonAdapter adapter = this.moshi.adapter(type, MoshiConverterFactory.jsonAnnotations(parameterAnnotations));
        if (this.lenient) {
            adapter = adapter.lenient();
        }
        return new MoshiRequestBodyConverter(adapter);
    }

    private static Set<? extends Annotation> jsonAnnotations(Annotation[] annotations) {
        LinkedHashSet<Annotation> result = null;
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(JsonQualifier.class)) continue;
            if (result == null) {
                result = new LinkedHashSet<Annotation>();
            }
            result.add(annotation);
        }
        return result != null ? Collections.unmodifiableSet(result) : Collections.emptySet();
    }
}

