/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.protobuf;

import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Converter;

final class ProtoResponseBodyConverter<T extends MessageLite>
implements Converter<ResponseBody, T> {
    private final Parser<T> parser;
    private final ExtensionRegistryLite registry;

    ProtoResponseBodyConverter(Parser<T> parser, ExtensionRegistryLite registry) {
        this.parser = parser;
        this.registry = registry;
    }

    public T convert(ResponseBody value) throws IOException {
        try {
            MessageLite messageLite = (MessageLite)this.parser.parseFrom(value.byteStream(), this.registry);
            return (T)messageLite;
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        finally {
            value.close();
        }
    }
}

