package com.stream.prt;

import com.stream.prt.utils.TorrentUtils;

public class RsaHelper {

    private static byte[] publicKey;
    private static byte[] privateKey;

    public static void setPublicKey(byte[] key) {
        publicKey = key;
    }

    public static void setPrivateKey(byte[] key) {
        privateKey = key;
    }

    public static void setPublicKey(String key) {
        publicKey = TorrentUtils.hexStringToByteArray(key);
    }

    public static void setPrivateKey(String key) {
        privateKey = TorrentUtils.hexStringToByteArray(key);
    }

    public static byte[] getPublicKey() {
        return publicKey;
    }

    public static byte[] getPrivateKey() {
        return privateKey;
    }

    public static byte[] encryptByPublicKey(byte[] data) {
        return RSAUtil.doByPublicKey(data, publicKey,true);
    }

    public static byte[] decryptByPublicKey(byte[] data) {
        return RSAUtil.doByPublicKey(data, publicKey,false);
    }

    public static byte[] encryptByPrivateKey(byte[] data) {
        return RSAUtil.doByPrivateKey(data, privateKey,true);
    }

    public static byte[] decryptByPrivateKey(byte[] data) {
        return RSAUtil.doByPrivateKey(data, privateKey,false);
    }
}
