package com.stream.prt.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 * AES加密方法类 采用 AES/CTR/NOPADDING 方式加解密,特点： 1.加密前后的数据长度不变 2.原始数据无需16/32字节对齐
 */
public class AESSecurityPrt {

    /*
     * 加密
     */
    public static byte[] encrypt(String key, byte[] data, int len) {
        Cipher cipher = createFileCipher(getEncryKey(key), 0, Cipher.ENCRYPT_MODE);
        if (cipher == null) {
            return null;
        }

        try {
            return cipher.doFinal(data, 0, len);
        } catch (IllegalBlockSizeException | BadPaddingException e) {
            // TODOAuto-generated catch block
            e.printStackTrace();
        }

        return null;
    }

    public static String encryptToBase64(String key, byte[] data) {
        byte[] crypted = encrypt(key, data, data.length);
        return Base64.encodeToString(crypted, Base64.URL_SAFE | Base64.NO_WRAP);
    }

    public static String decryptFromBase64(String key, String data) {
        byte[] dataBytes = Base64.decode(data, Base64.URL_SAFE | Base64.NO_WRAP);

        byte[] bytes = decrypt(key, dataBytes, dataBytes.length);
        return new String(bytes);
    }

    /*
     * 解密
     */
    public static byte[] decrypt(String key, byte[] data, int len) {
        Cipher cipher = createFileCipher(getEncryKey(key), 0, Cipher.DECRYPT_MODE);
        try {
            return cipher.doFinal(data, 0, len);
        } catch (IllegalBlockSizeException | BadPaddingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

    /********************* 下面是一些辅助函数 *******************************/
    /*
     * 获取key的sha256值
     */
    private static byte[] getEncryKey(String key) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(key.getBytes("utf-8"));
            return messageDigest.digest();
        } catch (NoSuchAlgorithmException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

    private static Cipher createFileCipher(byte[] fileKey, long startOffset, int mode) {
        // 生成IV变量
        final byte new_key[] = new byte[16];
        for (int j = 0; j < new_key.length; j++) {
            new_key[j] = (byte) (fileKey[j] ^ fileKey[j + 16]);
        }

        long ivCtr = (startOffset - (startOffset % 16)) / 16;

        byte[] ivCtrBytes = long2bytearray(ivCtr);
        final byte iv[] = new byte[]{fileKey[16], fileKey[17], fileKey[18], fileKey[19], fileKey[20], fileKey[21],
                fileKey[22], fileKey[23], ivCtrBytes[0], ivCtrBytes[1], ivCtrBytes[2], ivCtrBytes[3], ivCtrBytes[4],
                ivCtrBytes[5], ivCtrBytes[6], ivCtrBytes[7]};
        // 生成 Cipher
        Cipher in_aes = createCipherCTR(new_key, mode, iv);
        return in_aes;
    }

    private static Cipher createCipherCTR(byte key[], int mode, byte iv[]) {
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CTR/NOPADDING");
            cipher.init(mode, keySpec, ivSpec);
            return cipher;

        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] long2bytearray(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i >= 0; i--) {
            b[i] = (byte) val;
            val >>>= 8;
        }
        return b;
    }
}