package com.stream.prt;

import android.os.Debug;

import com.stream.prt.utils.AESSecurityPrt;
import com.stream.prt.utils.Base64;

public class PrtUtils {

    /**
     *
     * @param key
     * @param data
     * @return
     */
    public static byte[] AESEncrypt(String key, byte[] data) {
        return AESSecurityPrt.encrypt(key, data, data.length);
    }

    /**
     *
     * @param key
     * @param data
     * @return
     */
    public static byte[] AESDecrypt(String key, byte[] data) {
        return AESSecurityPrt.decrypt(key, data, data.length);
    }

    /**
     *
     * @param data
     * @return
     */
    public static byte[] Base64Decode(String data) {
        return Base64.decode(data, Base64.URL_SAFE | Base64.NO_WRAP);
    }

    /**
     *
     * @param data
     * @return
     */
    public static String Base64Encode(byte[] data) {
        return Base64.encodeToString(data, Base64.URL_SAFE | Base64.NO_WRAP);
    }

    public static String getJavaAndNativeHeapSize() {
        String ret = "native[" + Debug.getNativeHeapSize()/1024 + "KB," + Debug.getNativeHeapAllocatedSize()/1024 + "KB," + Debug.getNativeHeapFreeSize()/1024 +
                "KB],app[" +  Runtime.getRuntime().maxMemory()/1024 + "KB," + Runtime.getRuntime().totalMemory()/1024 + "KB," + Runtime.getRuntime().freeMemory()/1024 + "KB];";
        return ret;
    }

}
