package com.stream.prt;

import java.util.Map;

public class JniApi {
    private static final String TAG = JniApi.class.getSimpleName();
    private boolean haveLoad = false;
    private String preJniPathName = "";
    private String jniPathName = "";
    private static JniApi INSTANCE;

    public static String seperator_comma = ",";
    public static String seperator_and = "&";

    public synchronized static void init(String soPath) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new JniApi();
        INSTANCE.loadLib(soPath);
    }

    public static final JniApi getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("JniApi is not initialized!");
        }
        return INSTANCE;
    }

//    private static class Holder {
//        private static final JniApi INSTANCE = new JniApi();
//    }

//    public static final JniApi getInstance() {
//        return Holder.INSTANCE;
//    }

    private JniApi() {
//        String path = FileUtil.getSoLibsPath(ContextProvider.getContext());
//        loadlib(path);
    }

    private void loadLib(String path) {
        if (!this.haveLoad) {
            Class var2 = JniApi.class;
            synchronized (JniApi.class) {
                if (!this.haveLoad) {
                    if (path != null && path.length() > 0) {
                        label30:
                        {
                            try {
                                System.load(path);
                                this.haveLoad = true;
                                this.jniPathName = path;
                            } catch (Throwable var5) {
                                break label30;
                            }

                            return;
                        }
                    }

                    System.loadLibrary("jni-lib");
                    this.haveLoad = true;
                }
            }
        }

//        try {
//            boolean isLoadPath = false;
//            if (!TextUtils.isEmpty(path)) {
//                File file = new File(path);
//                if (file != null && file.exists()) {
//                    int lastAppVersion = CommonPreference.getInstance().getInt(PreferenceConstant.KEY_SO_UPDATE_APP_VERSION, -1);
//                    Log.i(TAG, "loadlib lastAppVersion:" + lastAppVersion + ",currentVersion:" + AppUtils.getVersionCode());
//                    if (lastAppVersion == AppUtils.getVersionCode()) {
//                        isLoadPath = true;
//                    } else {
//                        FileUtil.deleteFile(path);
//                    }
//                }
//            }
//
//            boolean canLoad = false;
//            if (!path.equals(this.preJniPathName)) {
//                this.preJniPathName = path;
//                canLoad = true;
//            } else if (!this.haveLoad) {
//                canLoad = true;
//            }
//
//            Log.i(TAG, "loadlib path:" + path + ",canLoad:" + canLoad + ",isLoadPath:" + isLoadPath);
//
//            if (canLoad) {
//                if (isLoadPath) {
//                    System.load(path);
//                } else {
//                    System.loadLibrary("jni-lib");
//                }
//            }
//            this.haveLoad = true;
//        } catch (Exception e) {
//            e.printStackTrace();
//            Log.e(TAG, "load jni-lib error");
//        }
    }

    public String getJniPathName() {
        return this.jniPathName;
    }

    public native int init(String workPath, String cfgFile, Map<String, String> params);

    public native int uninit();

    // 直播调用
    public native int startChannel(String sysParams, String channParams, Map<String, String> params);

    // 如果把mptUrl按key:value格式放在channParams，解析会有问题
    // 点播调用 startVodChannel
    public native int startVodChannel(String channParams, String mptContent);

    public native int requestData(int channelId, long offset);

    public native int requestDataByBlockName(int channelId, String blockName);

    public native int requestDataFromBlockName(int channelId, String blockName);

    public native String getChannelM3u8(String chanHash);

    public native int setChannelState(String chanHash, int downState, int cacheState);

    public native String getLocalChannels();

    public native int stopChannel(int channelId);

    public native int setParam(String cfg, Object value);

    public int setNetworkState(NetworkState state, String localIp) {
        return this.setNetworkState(state.ordinal(), localIp);
    }

    public native int setNetworkState(int state, String localIp);

    public native int setTransMask(int mask);

    public native void setUpnpResult(int channelId, String ipList);

    public native void setLog(boolean enable, int period); // period : ms

    public native int flushLog();

    public native int getRand();

    public native String getVersion();

    public native byte[] encryptByPrivateKey(byte[] content, byte[] key);

    public native byte[] decryptByPrivateKey(byte[] content, byte[] key);

    public native byte[] encryptByPublicKey(byte[] content, byte[] key);

    public native byte[] decryptByPublicKey(byte[] content, byte[] key);

    public native int prtEngineInit(String workPath, String cfgFile, String logFile);

    public native void notifyBuffering(int channelId, int times, int ms);

    public native void updateChannel(int var1, String var2);

    public native boolean isBlockCached(int chanId, int blockId);

    public native String getCurrentPrtId();

    public native void sendFrontLog(int chanId, String log);
}
