package com.stream.prt.log;

/**
 * Created by elegant.wang on 2016/9/6.
 */
public class DefaultLogger implements LoggerInterface {
    @Override
    public void log(int priority, String tag, String message, Throwable t) {
        //System.out.println(message);
        String text = String.format("%s: %s", tag, message);
        switch (priority) {
            case Logger.ERROR:
                if (t == null) LogUtils.e(text);
                else LogUtils.e(t, text);
                break;
            case Logger.WARN:
                if (t == null) LogUtils.w(text);
                else LogUtils.w(t, text);
                break;
            case Logger.INFO:
                if (t == null) LogUtils.i(text);
                else LogUtils.i(t, text);
                break;
            case Logger.DEBUG:
                if (t == null) LogUtils.d(text);
                else LogUtils.d(t, text);
                break;
            case Logger.TRACE:
                if (t == null) LogUtils.w(text);
                else LogUtils.w(t, text);
                break;
            case Logger.NONE:
                break;
        }
    }
}
