package com.stream.prt.utils;

import com.stream.prt.JniApi;
import com.stream.prt.NetworkState;
import com.stream.prt.log.Logger;
import com.stream.prt.log.LoggerFactory;

import java.util.Map;

/**
 * Created by Joyce.wang on 2022/4/19.
 */
public class JniApiImpl {
    private final static Logger logger = LoggerFactory.getLogger(JniApiImpl.class.getName());
    private static final String TAG = JniApiImpl.class.getSimpleName();
    private boolean haveLoad = false;
    private String jniPathName = "";
    private JniApi jniApi;
    private static JniApiImpl INSTANCE;

    public static String seperator_comma = ",";
    public static String seperator_and = "&";

    public synchronized static void init(String soPath) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new JniApiImpl();
        INSTANCE.loadLib(soPath);
    }

    public static final JniApiImpl getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("JniApiImpl is not initialized!");
        }
        return INSTANCE;
    }

    private JniApiImpl() {
        jniApi = new JniApi();
    }

    private void loadLib(String path) {
        if (!this.haveLoad) {
            Class var2 = JniApi.class;
            synchronized (JniApi.class) {
                if (!this.haveLoad) {
                    if (path != null && path.length() > 0) {
                        label30:
                        {
                            try {
                                System.load(path);
                                this.haveLoad = true;
                                this.jniPathName = path;
                            } catch (Throwable var5) {
                                break label30;
                            }

                            return;
                        }
                    }

                    System.loadLibrary("jni-lib");
                    this.haveLoad = true;
                }
            }
        }
    }

    public int init(String workPath, String cfgFile, Map<String, String> params) {
        if (isLoad()) {
            return jniApi.init(workPath, cfgFile, params);//错误返回-2，成功返回0
        }
        return -1;
    }

    public int uninit() {
        if (isLoad()) {
            return jniApi.uninit();//返回0
        }
        return -1;
    }

    // 直播调用
    public int startChannel(String sysParams, String channParams, Map<String, String> params) {
        if (isLoad()) {
            return jniApi.startChannel(sysParams, channParams, params);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    // 如果把mptUrl按key:value格式放在channParams，解析会有问题
    // 点播调用 startVodChannel
    public int startVodChannel(String channParams, String mptContent) {
        if (isLoad()) {
            return jniApi.startVodChannel(channParams, mptContent);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    public int requestData(int channelId, long offset) {
        if (isLoad()) {
            return jniApi.requestData(channelId, offset);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    public int requestDataByBlockName(int channelId, String blockName) {
        if (isLoad()) {
            return jniApi.requestDataByBlockName(channelId, blockName);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    public int requestDataFromBlockName(int channelId, String blockName) {
        if (isLoad()) {
            return jniApi.requestDataFromBlockName(channelId, blockName);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    public String getChannelM3u8(String chanHash) {
        if (isLoad()) {
            return jniApi.getChannelM3u8(chanHash);
        }
        return "";
    }

    public int setChannelState(String chanHash, int downState, int cacheState) {
        if (isLoad()) {
            return jniApi.setChannelState(chanHash, downState, cacheState);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    public String getLocalChannels() {
        if (isLoad()) {
            return jniApi.getLocalChannels();
        }
        return "";
    }

    public int stopChannel(int channelId) {
        if (isLoad()) {
            return jniApi.stopChannel(channelId);//返回0
        }
        return -1;
    }

    public int setParam(String cfg, Object value) {
        if (isLoad()) {
            return jniApi.setParam(cfg, value);//返回0
        }
        return -1;
    }

    public int setNetworkState(NetworkState state, String localIp) {
        return setNetworkState(state.ordinal(), localIp);
    }

    public int setNetworkState(int state, String localIp) {
        if (isLoad()) {
            return jniApi.setNetworkState(state, localIp);//出错返回-1，成功返回0
        }
        return -1;
    }

    public int setTransMask(int mask) {
        if (isLoad()) {
            return jniApi.setTransMask(mask);//返回0
        }
        return -1;
    }

    public void setUpnpResult(int channelId, String ipList) {
        if (isLoad()) {
            jniApi.setUpnpResult(channelId, ipList);//返回0
        }
    }

    // period : ms
    public void setLog(boolean enable, int period) {
        if (isLoad()) {
            jniApi.setLog(enable, period);//返回0
        }
    }

    public int flushLog() {
        if (isLoad()) {
            return jniApi.flushLog();//返回0
        }
        return -1;
    }

    public int getRand() {
        if (isLoad()) {
            return jniApi.getRand();//返回 > 0
        }
        return -1;
    }

    public String getVersion() {
        if (isLoad()) {
            return jniApi.getVersion();
        }
        return "";
    }

    public byte[] encryptByPrivateKey(byte[] content, byte[] key) {
        if (isLoad()) {
            return jniApi.encryptByPrivateKey(content, key);
        }
        return null;
    }

    public byte[] decryptByPrivateKey(byte[] content, byte[] key) {
        if (isLoad()) {
            return jniApi.decryptByPrivateKey(content, key);
        }
        return null;
    }

    public byte[] encryptByPublicKey(byte[] content, byte[] key) {
        if (isLoad()) {
            return jniApi.encryptByPublicKey(content, key);
        }
        return null;
    }

    public byte[] decryptByPublicKey(byte[] content, byte[] key) {
        if (isLoad()) {
            return jniApi.decryptByPublicKey(content, key);
        }
        return null;
    }

    public int prtEngineInit(String workPath, String cfgFile, String logFile) {
        if (isLoad()) {
            return jniApi.prtEngineInit(workPath, cfgFile, logFile);//返回0
        }
        return -1;
    }

    public void notifyBuffering(int channelId, int times, int ms) {
        if (isLoad()) {
            jniApi.notifyBuffering(channelId, times, ms);
        }
    }

    public void updateChannel(int var1, String var2) {
        if (isLoad()) {
            jniApi.updateChannel(var1, var2);
        }
    }

    public boolean isBlockCached(int chanId, int blockId) {
        if (isLoad()) {
            return jniApi.isBlockCached(chanId, blockId);//没有返回0，有返回1
        }
        return false;
    }

    public void sendFrontLog(int chanId, String log) {
        if (isLoad()) {
            jniApi.sendFrontLog(chanId, log);
        }
    }

    public String getCurrentPrtId() {
        if (isLoad()) {
            return jniApi.getCurrentPrtId();
        }
        return "";
    }

    public int setAndGetPort(int port) {
        if (isLoad()) {
            return jniApi.setAndGetPort(port);
        }
        return -1;
    }

    public void initEngineProxyBuffer(int chanId, int requestId, int blockLen, int solutionType, int solutionBrand, String drmKeyLink, int mode) {
        if (isLoad()) {
            jniApi.initEngineProxyBuffer(chanId, requestId, blockLen, solutionType, solutionBrand, drmKeyLink, mode);
        }
    }

    public void closeEngineProxyBuffer(int chanId) {
        if (isLoad()) {
            jniApi.closeEngineProxyBuffer(chanId);
        }
    }

    public void setBlockDecryptKey(int chanId, String key) {
        if (isLoad()) {
            jniApi.setBlockDecryptKey(chanId, key);
        }
    }

    private boolean isLoad() {
        if (!haveLoad) {
            logger.warn(TAG, "no load engine so");
        }
        return haveLoad;
    }

    public String getJniPathName() {
        return this.jniPathName;
    }
}
