package com.stream.prt;

import java.util.Map;

public class JniApi {

    public native int init(String workPath, String cfgFile, Map<String, String> params);

    public native int uninit();

    // 直播调用
    public native int startChannel(String sysParams, String channParams, JniPrtListener listener, Map<String, String> params);

    // 如果把mptUrl按key:value格式放在channParams，解析会有问题
    // 点播调用 startVodChannel
    public native int startVodChannel(String channParams, String mptContent);

    public native int requestData(int channelId, long offset);

    public native int requestDataByBlockName(int channelId, String blockName);

    public native int requestDataFromBlockName(int channelId, String blockName);

    public native String getChannelM3u8(String chanHash);

    public native int setChannelState(String chanHash, int downState, int cacheState);

    public native String getLocalChannels();

    public native int stopChannel(int channelId);

    public native int setParam(String cfg, Object value);

    public native int setNetworkState(int state, String localIp);

    public native int setTransMask(int mask);

    public native void setUpnpResult(int channelId, String ipList);

    public native void setLog(boolean enable, int period); // period : ms

    public native int flushLog();

    public native int getRand();

    public native String getVersion();

    public native byte[] encryptByPrivateKey(byte[] content, byte[] key);

    public native byte[] decryptByPrivateKey(byte[] content, byte[] key);

    public native byte[] encryptByPublicKey(byte[] content, byte[] key);

    public native byte[] decryptByPublicKey(byte[] content, byte[] key);

    public native int prtEngineInit(String workPath, String cfgFile, String logFile);

    public native void notifyBuffering(int channelId, int times, int ms);

    public native void updateChannel(int var1, String var2);

    public native boolean isBlockCached(int chanId, int blockId);

    public native String getCurrentPrtId();

    public native void sendFrontLog(int chanId, String log);

    public native int setAndGetPort(int port);

    public native void initEngineProxyBuffer(int chanId, int blockLen, long resTotalLen, int solutionType, int solutionBrand, String drmKeyLink, int mode);

    public native void closeEngineProxyBuffer(int chanId);

    public native void setBlockDecryptKey(int chanId, String key);

    public native int getDownSpeed(int chanId);

    public native int requestVodInfoToPlay(String channParams, String mptContent);
}
