package com.stream.prt;

import com.stream.prt.log.Logger;
import com.stream.prt.log.LoggerFactory;

import java.util.Map;

/* JNI静态反式调用 */
public class PrtCallBack {
    private final static Logger logger = LoggerFactory.getLogger(PrtCallBack.class.getName());

    public static final int EVENT_VOD_DOWN_PROGRESS = 0x2001;
    public static final int EVENT_VOD_AUTO_CACHE_MAX_SIZE = 0x2002;
    public static final int EVENT_VOD_USER_CACHE_INSUFFICIENT_SIZE = 0x2003;

    public static final int DEFAULT_REQUEST_ID = 8383;

    //直播收到数据
    public static int onDataAvail(int channelId, int blockId, byte[] data) {
        logger.debug("PrtCallBack onDataAvail channelId:%d requestId:%d blockId:%d dataLen:%d:", channelId, blockId, data.length);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, DEFAULT_REQUEST_ID);
        logger.debug("PrtCallBack onDataAvail listener:" + listener);
        if (listener != null) {
            return listener.onDataAvail(channelId, blockId, data);
        } else {
            return data.length;
        }
    }

    //直播收到数据
    public static int onDataAvail(int channelId, int blockId, byte[] data, int offset, int len) {
        logger.debug("PrtCallBack onDataAvail channelId:%d blockId:%d offset:%d dataLen:%d:", channelId, blockId, offset, data.length);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, DEFAULT_REQUEST_ID);
        logger.debug("PrtCallBack onDataAvail listener:" + listener);
        if (listener != null) {
            return listener.onDataAvail(channelId, blockId, data, offset, len);
        } else {
            return data.length;
        }
    }

    //直播收到数据
    public static int onDataAvail(int channelId, int blockId, byte[] data, int offset, int len, long timeout) {
        logger.debug("PrtCallBack onDataAvail channelId:%d blockId:%d offset:%d dataLen:%d:", channelId, blockId, offset, data.length);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, DEFAULT_REQUEST_ID);
        logger.debug("PrtCallBack onDataAvail listener:" + listener);
        if (listener != null) {
            return listener.onDataAvail(channelId, blockId, data, offset, len, timeout);
        } else {
            return data.length;
        }
    }

    //点播收到数据
    public static int onDataAvail(int channelId, int blockId, byte[] data, long offset, int requestId, int waitMs) {
        logger.debug("PrtCallBack onDataAvail channelId:%d requestId:%d blockId:%d offset:%d dataLen:%d:", channelId, requestId, blockId, offset, data.length);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, requestId);
        logger.debug("PrtCallBack onDataAvail listener:" + listener);
        if (listener != null) {
            return listener.onDataAvail(channelId, requestId, blockId, data, offset, waitMs);
        } else {
            return data.length;
        }
    }

    //点播
    public static int onCheckRecvDataBuffer(int channelId, int blockId, int len, long offset, int requestId) {
        int avail = 0;
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, requestId);
        if (listener != null) {
            avail = listener.onCheckRecvDataBuffer(requestId, blockId, len, offset);
        }
        logger.debug("PrtCallBack onCheckRecvDataBuffer channelId:%d requestId:%d blockId:%d offset:%d len:%d avail:%d", channelId, requestId, blockId, offset, len, avail);
        return avail;
    }

    public static int onDataAvail(int channelId, int blockId, byte[] data, int offsetInBlock, int offsetInFile, int len, long timeout) {
        logger.debug("onDataAvail, channelId:%d blockId:%d offsetInBlock:%d offsetInFile:%d len:%d timeout:%d", channelId, blockId, offsetInBlock, offsetInFile, len, timeout);
        return 0;
    }

    public static int onMetric(int channelId, PrtMetric var2) {
        logger.debug("PrtCallBack onMetric 1, channelId:%d", channelId);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, DEFAULT_REQUEST_ID);
        if (listener != null) {
            return listener.onMetric(channelId, var2);
        }
        return 0;
    }

    public static int onMetric(int channelId, Map<String, String> var2) {
        logger.debug("PrtCallBack onMetric 2, channelId:%d", channelId);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, DEFAULT_REQUEST_ID);
        if (listener != null) {
            return listener.onMetric(channelId, var2);
        }
        return 0;
    }

    public static int onState(int channelId, Map<String, String> var2) {
        logger.debug("PrtCallBack onState, channelId:%d", channelId);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, DEFAULT_REQUEST_ID);
        if (listener != null) {
            return listener.onState(channelId, var2);
        }
        return 0;
    }

    public static void onVersion(String version) {
        logger.debug("version: " + version);
    }

    public static void onNatReq(int channelId, String var2, int var3) {
        logger.debug("PrtCallBack onNatReq, channelId:%d", channelId);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, DEFAULT_REQUEST_ID);
        if (listener != null) {
            listener.onNatReq(channelId, var2, var3);
        }
    }

    public static void onEvent(int channelId, int var2, String var3, String var4) {
        logger.debug("PrtCallBack onEvent, channelId:%d", channelId);
        if(var2 == EVENT_VOD_DOWN_PROGRESS || var2 == EVENT_VOD_USER_CACHE_INSUFFICIENT_SIZE) {
            PrtListenerManager.PrtCacheEventListener prtCacheEventListener = PrtListenerManager.getInstance().getPrtCacheEventListener();
            if (prtCacheEventListener != null) {
                prtCacheEventListener.onCacheEvent(channelId, var2, var3, var4);
            }
        } else {
            JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, DEFAULT_REQUEST_ID);
            if (listener != null) {
                listener.onEvent(channelId, var2, var3, var4);
            }
        }
    }

    public static int getPlayerCacheTime(int channelId) {
        logger.debug("PrtCallBack getPlayerCacheTime, channelId:%d", channelId);
        JniPrtListener listener = PrtListenerManager.getInstance().findListener(channelId, DEFAULT_REQUEST_ID);
        if (listener != null) {
            return listener.getPlayerCacheTime(channelId);
        }
        return 0;
    }
}
