package com.stream.prt;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

import javax.crypto.Cipher;

/**
 * RSA加解密工具类
 * 数据保存为 16进制内容,虽然长一些,但没有base64的敏感字符,转换效率也高doBypublicKey一些
 *
 */
public class RSAUtil {

    public static byte[] publicKey = null;  //公钥
    /**
     * 私钥匙加密或解密
     * @param content
     * @param privateKeyA
     * @return
     */
    public static byte[] doByPrivateKey(byte[] content,byte[] privateKeyA,boolean bEncrypt){
        int opmode = bEncrypt?Cipher.ENCRYPT_MODE:Cipher.DECRYPT_MODE;
        //私钥要用PKCS8进行处理
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyA);
        KeyFactory keyFactory;
        PrivateKey privateKey;
        Cipher cipher;
        byte[] result = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            //还原Key对象
            privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            cipher = Cipher.getInstance("RSA");
            cipher.init(opmode, privateKey);
            if(opmode == Cipher.ENCRYPT_MODE){  //加密
                result = cipher.doFinal(content);
            }else if(opmode == Cipher.DECRYPT_MODE){  //解密
                result = cipher.doFinal(content);
            }

        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }catch (Throwable e) {
            e.printStackTrace();
        }

        return result;
    }

    /**
     * 公钥匙加密或解密
     * @param content
     * @param publicKeyA
     * @return
     */
    public static byte[] doByPublicKey(byte[] content,byte[] publicKeyA,boolean bEncrypt){
        int opmode = bEncrypt?Cipher.ENCRYPT_MODE:Cipher.DECRYPT_MODE;
        //公钥要用X509进行处理
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKeyA);
        KeyFactory keyFactory;
        PublicKey publicKey;
        Cipher cipher;
        byte[] result = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            //还原Key对象
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            cipher = Cipher.getInstance("RSA");
            cipher.init(opmode, publicKey);
            if(opmode == Cipher.ENCRYPT_MODE){  //加密
                result = cipher.doFinal(content);
            }else if(opmode == Cipher.DECRYPT_MODE){  //解密
                result = cipher.doFinal(content);
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 私钥匙加密或解密
     * @param content
     * @param privateKeyStr
     * @return
     */
   /* public static byte[] doByPrivateKey1(byte[] content,byte[] privateKeyA,boolean bEncrypt){
        int opmode = bEncrypt?Cipher.ENCRYPT_MODE:Cipher.DECRYPT_MODE;
        //私钥要用PKCS8进行处理
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyA);
        KeyFactory keyFactory;
        PrivateKey privateKey;
        Cipher cipher;

        Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
        byte[] result = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA", new BouncyCastleProvider());
            //还原Key对象
            privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            cipher = Cipher.getInstance("RSA", new BouncyCastleProvider());
            cipher.init(opmode, privateKey);
            if(opmode == Cipher.ENCRYPT_MODE){  //加密
                result = cipher.doFinal(content);
            }else if(opmode == Cipher.DECRYPT_MODE){  //解密
                result = cipher.doFinal(content);
            }

        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }catch (Throwable e) {
            e.printStackTrace();
        }

        return result;
    }*/

    /**
     * 公钥匙加密或解密
     * @param content
     * @param privateKeyStr
     * @return
     */
    /*public static byte[] doByPublicKey1(byte[] content,byte[] publicKeyA,boolean bEncrypt){
        int opmode = bEncrypt?Cipher.ENCRYPT_MODE:Cipher.DECRYPT_MODE;
        //公钥要用X509进行处理
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKeyA);
        KeyFactory keyFactory;
        PublicKey publicKey;
        Cipher cipher;
        Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
        byte[] result = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA", new BouncyCastleProvider());
            //还原Key对象
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            cipher = Cipher.getInstance("RSA", new BouncyCastleProvider());
            cipher.init(opmode, publicKey);
            if(opmode == Cipher.ENCRYPT_MODE){  //加密
                result = cipher.doFinal(content);
            }else if(opmode == Cipher.DECRYPT_MODE){  //解密
                result = cipher.doFinal(content);
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }*/
}