package com.stream.prt.log;

import android.util.Log;

public class LogUtils {
    private final static String TAG = "c_prt";
    public static int LOG_LEVEL  = 2;
    public static int VERBOSE  = 5;
    public static int DEBUG  = 4;
    public static int INFO  = 3;
    public static int WARN  = 2;
    public static int ERROR  = 1;

    public static void setLogLevel(int level) {
        LOG_LEVEL = level;
    }

    public static void v(String format, Object... args){
        if(LOG_LEVEL>=VERBOSE){
            String msg = String.format(format, args);
            Log.v(TAG, msg);
        }
    }

    public static void d(String format, Object... args){
        if(LOG_LEVEL>=DEBUG){
            String msg = String.format(format, args);
            Log.d(TAG, msg);
        }
    }

    public static void d(Throwable e, String format, Object... args){
        if(LOG_LEVEL>=DEBUG){
            String msg = String.format(format, args);
            Log.d(TAG, msg, e);
        }
    }

    public static void i(String format, Object... args){
        if(LOG_LEVEL>=INFO){
            String msg = String.format(format, args);
            Log.i(TAG, msg);
        }
    }
    public static void i(Throwable e, String format, Object... args){
        if(LOG_LEVEL>=INFO){
            String msg = String.format(format, args);
            Log.i(TAG, msg, e);
        }
    }
    public static void w(String format, Object... args){
        if(LOG_LEVEL>=WARN){
            String msg = String.format(format, args);
            Log.w(TAG, msg);
        }
    }

    public static void w(Throwable e, String format, Object... args){
        if(LOG_LEVEL>=WARN){
            String msg = String.format(format, args);
            Log.w(TAG, msg, e);
        }
    }
    public static void e(String format, Object... args){
        if(LOG_LEVEL>=ERROR){
            String msg = String.format(format, args);
            Log.e(TAG, msg);
        }
    }
    public static void e(Throwable e, String format, Object... args){
        if(LOG_LEVEL>=ERROR){
            String msg = String.format(format, args);
            Log.e(TAG, msg, e);
        }
    }
}
