package com.stream.prt.utils;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class TorrentUtils {
    private final static int RS_HASH_MULTIPLIER = 33;
    private final static char[] HEX_SYMBOLS = "0123456789ABCDEF".toCharArray();
    protected final static Charset charset = Charset.forName("UTF-8");
    
    public static Charset getCharset() {
        return charset;
    }
  /**
   * @param data for hashing
   * @return sha 1 hash of specified data
   */  
  public static byte[] calculateSha1Hash(byte[] data) {    
      try {
          MessageDigest md = MessageDigest.getInstance("SHA-1");
          data = md.digest(data);
          return data;
      } catch (NoSuchAlgorithmException e) {
          throw new RuntimeException(e);
      }
	  //return DigestUtils.sha1(data);
  }
  
  /*
   * 2019-02-14 zjb
   * 增加和引擎对接的hashV计算函数
   */
  public static int calculateHashV(byte[] data) {
      int hashV = 0;
      for(int i = 0;i < data.length;i++) {
          hashV = hashV * RS_HASH_MULTIPLIER + data[i];
      }
      return hashV;
  }

  /**
   * Convert a byte string to a string containing an hexadecimal
   * representation of the original data.
   *
   * @param bytes The byte array to convert.
   */
    public static String byteArrayToHexString(byte[] bytes) {
    if (bytes == null) {
        return "";
    }
    char[] hexChars = new char[bytes.length * 2];
    for (int j = 0; j < bytes.length; j++) {
        int v = bytes[j] & 0xFF;
        hexChars[j * 2] = HEX_SYMBOLS[v >>> 4];
        hexChars[j * 2 + 1] = HEX_SYMBOLS[v & 0x0F];
    }
    return new String(hexChars);
  }
  
  
  public static byte[] hexStringToByteArray(String hexString) {
      if ((hexString == null) || ("".equals(hexString))) {
          return null;
      }
      
      hexString = hexString.toLowerCase();
      final byte[] byteArray = new byte[hexString.length() / 2];
      int k = 0;
      for (int i = 0; i < byteArray.length; i++)
      {
          byte high = (byte) (Character.digit(hexString.charAt(k), 16) & 0xff);
          byte low = (byte) (Character.digit(hexString.charAt(k + 1), 16) & 0xff);
          byteArray[i] = (byte) (high << 4 | low);
          k += 2;
      }
      return byteArray;
  }
  /*
   * 判断2组是否是相同的sha1
   */
  public static boolean isSameSha1Hash(byte[] dt1,byte[] dt2) {
      if ((dt1 == null) || (dt2 == null)) {
          return false;
      }
      if ((dt1.length != 20) || (dt2.length != 20)) {
          return false;
      }
      
      return Arrays.equals(dt1,dt2);
  }
  
  public static boolean isSameSha1Hash(byte[] dt1,int from,byte[] dt2) {
      if ((dt1 == null) || (dt2 == null)) {
          return false;
      }
      
      if ((dt1.length < (from + 20)) || (dt2.length != 20)) {
          return false;
      }
      
      for(int i = 0;i < 20;i++)
      {
          if (dt1[i + from] != dt2[i]) {
              return false;
          }
      }
      
      return true;
  }
  
  /*
   * 判断是否为hexHash
   */
  public static boolean isHexHash(String uri) {
      if ((uri == null) || (uri.length() != 40)) {
          return false;
      }
      byte[] uris = uri.getBytes();
      for(int i = 0;i < 20;i++) {
          char ch = (char) uris[i];
          if ((ch >= '0') && (ch <= '9')) {
              continue;
          }
          if ((ch >= 'A') && (ch <= 'F')) {
              continue;
          }
          if ((ch >= 'a') && (ch <= 'f')) {
              continue;
          }
          return false;
      }
      return true;
  }
  
  /*
   * 返回天花板数.
   * 不支持div小于等于0
   */
  public static int ceilDiv(int total,int div) {
      if (div <= 0) {
          return 0;
      }
      
      return (total + div - 1)/div;
  }
}
