package com.stream.prt.utils;

import com.bikcore.BikCore;
import com.stream.prt.JniApi;
import com.stream.prt.NetworkState;
import com.stream.prt.log.Logger;
import com.stream.prt.log.LoggerFactory;

import java.util.Map;

/**
 * Created by Joyce.wang on 2022/4/19.
 */
public class JniApiImpl {
    private final static Logger logger = LoggerFactory.getLogger(JniApiImpl.class.getName());
    private static final String TAG = JniApiImpl.class.getSimpleName();

    //drm type
    final public static int DRMTYPE_NODRM = 0;
    final public static int DRMTYPE_GOOSE = 1;
    final public static int DRMTYPE_IRDETO = 2;

    //solution type
    final public static int SOLUTION_TYPE_NONE = 0;
    final public static int SOLUTION_TYPE_MPT = 1;
    final public static int SOLUTION_TYPE_MPQ = 2;
    final public static int SOLUTION_TYPE_VALO_HLS = 3;
    final public static int SOLUTION_TYPE_DRM_HLS = 4;
    final public static int SOLUTION_TYPE_DRM_DASH = 5;
    final public static int SOLUTION_TYPE_VOD_PLAIN_RPD = 6;
    final public static int SOLUTION_TYPE_VOD_DRM_HLS = 7;
    final public static int SOLUTION_TYPE_VOD_DRM_DASH = 8;
    final public static int SOLUTION_TYPE_LIVE_PLAIN_RPD = 9;
    final public static int SOLUTION_TYPE_VOD_TIMESHIFT_PLAIN_RPD = 100;
    final public static int SOLUTION_TYPE_VOD_TIMESHIFT_DRM_HLS = 101;
    final public static int SOLUTION_TYPE_VOD_TIMESHIFT_DRM_DASH = 102;

    private boolean haveLoad = false;
    private String jniPathName = "";
    private JniApi jniApi;
    private static JniApiImpl INSTANCE;

    public static String seperator_comma = ",";
    public static String seperator_and = "&";

    public synchronized static void init(String bikcoreSoPath, String jniLibSoPath) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new JniApiImpl();
        INSTANCE.loadBikcore(bikcoreSoPath);
        INSTANCE.loadLib(jniLibSoPath);
    }

    public synchronized static void init(String soPath) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new JniApiImpl();
        INSTANCE.loadBikcore("");
        INSTANCE.loadLib(soPath);
    }

    public static final JniApiImpl getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("JniApiImpl is not initialized!");
        }
        return INSTANCE;
    }

    private JniApiImpl() {
        jniApi = new JniApi();
    }

    private void loadBikcore(String path) {
        BikCore.init(path);
    }

    private void loadLib(String path) {
        if (haveLoad) {
            return;
        }

        synchronized (JniApi.class) {
            if (haveLoad) return;
            if (path != null && path.length() > 0) {
                try {
                    System.load(path);
                    haveLoad = true;
                    jniPathName = path;
                    return;
                } catch (Throwable t) {
                    logger.error(t, "loadLib failed: " + path);
                }
            }

            System.loadLibrary("jni-lib");
            haveLoad = true;
        }
    }

    public int init(String workPath, String cfgFile, Map<String, String> params) {
        if (isLoad()) {
            return jniApi.init(workPath, cfgFile, params);//错误返回-2，成功返回0
        }
        return -1;
    }

    public int uninit() {
        if (isLoad()) {
            return jniApi.uninit();//返回0
        }
        return -1;
    }

    // 直播调用
    public int startChannel(String sysParams, String channParams, Map<String, String> params) {
        if (isLoad()) {
            return jniApi.startChannel(sysParams, channParams, null, params);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    // 如果把mptUrl按key:value格式放在channParams，解析会有问题
    // 点播调用 startVodChannel
    public int startVodChannel(String channParams, String mptContent) {
        if (isLoad()) {
            return jniApi.startVodChannel(channParams, mptContent);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    public int requestData(int channelId, long offset) {
        if (isLoad()) {
            return jniApi.requestData(channelId, offset);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    public int requestDataByBlockName(int channelId, String blockName) {
        if (isLoad()) {
            return jniApi.requestDataByBlockName(channelId, blockName);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    public int requestDataFromBlockName(int channelId, String blockName) {
        if (isLoad()) {
            return jniApi.requestDataFromBlockName(channelId, blockName);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    public String getChannelM3u8(String chanHash) {
        if (isLoad()) {
            return jniApi.getChannelM3u8(chanHash);
        }
        return "";
    }

    public int setChannelState(String chanHash, int downState, int cacheState) {
        if (isLoad()) {
            return jniApi.setChannelState(chanHash, downState, cacheState);//出错返回-1，成功返回 > 0
        }
        return -1;
    }

    public String getLocalChannels() {
        if (isLoad()) {
            return jniApi.getLocalChannels();
        }
        return "";
    }

    public int stopChannel(int channelId) {
        if (isLoad()) {
            return jniApi.stopChannel(channelId);//返回0
        }
        return -1;
    }

    public int setParam(String cfg, Object value) {
        if (isLoad()) {
            return jniApi.setParam(cfg, value);//返回0
        }
        return -1;
    }

    public int setNetworkState(NetworkState state, String localIp) {
        return setNetworkState(state.ordinal(), localIp);
    }

    public int setNetworkState(int state, String localIp) {
        if (isLoad()) {
            return jniApi.setNetworkState(state, localIp);//出错返回-1，成功返回0
        }
        return -1;
    }

    public void setRunningMode(int mode) {
        if (isLoad()) {
            jniApi.setRunningMode(mode);
        }
    }

    public int setTransMask(int mask) {
        if (isLoad()) {
            return jniApi.setTransMask(mask);//返回0
        }
        return -1;
    }

    public void setUpnpResult(int channelId, String ipList) {
        if (isLoad()) {
            jniApi.setUpnpResult(channelId, ipList);//返回0
        }
    }

    // period : ms
    public void setLog(boolean enable, int period) {
        if (isLoad()) {
            jniApi.setLog(enable, period);//返回0
        }
    }

    public int flushLog() {
        if (isLoad()) {
            return jniApi.flushLog();//返回0
        }
        return -1;
    }

    public int getRand() {
        if (isLoad()) {
            return jniApi.getRand();//返回 > 0
        }
        return -1;
    }

    public String getVersion() {
        if (isLoad()) {
            return jniApi.getVersion();
        }
        return "";
    }

    public int getDigitalVersion() {
        if (isLoad()) {
            return jniApi.getDigitalVersion();
        }
        return 0;
    }

    public byte[] aesEncrypt(byte[] key, byte[] data, int toBase64, int padding) {
        if (isLoad()) {
            return jniApi.aesEncrypt(key, data, toBase64, padding);
        }
        return null;
    }

    public byte[] aesDecrypt(byte[] key, byte[] data, int fromBase64) {
        if (isLoad()) {
            return jniApi.aesDecrypt(key, data, fromBase64);
        }
        return null;
    }

    public byte[] encryptByPrivateKey(byte[] content, byte[] key) {
        if (isLoad()) {
            return jniApi.encryptByPrivateKey(content, key);
        }
        return null;
    }

    public byte[] decryptByPrivateKey(byte[] content, byte[] key) {
        if (isLoad()) {
            return jniApi.decryptByPrivateKey(content, key);
        }
        return null;
    }

    public byte[] encryptByPublicKey(byte[] content, byte[] key) {
        if (isLoad()) {
            return jniApi.encryptByPublicKey(content, key);
        }
        return null;
    }

    public byte[] decryptByPublicKey(byte[] content, byte[] key) {
        if (isLoad()) {
            return jniApi.decryptByPublicKey(content, key);
        }
        return null;
    }

    public int prtEngineInit(String workPath, String cfgFile, String logFile) {
        if (isLoad()) {
            return jniApi.prtEngineInit(workPath, cfgFile, logFile);//返回0
        }
        return -1;
    }

    public void notifyBuffering(int channelId, int times, int ms) {
        if (isLoad()) {
            jniApi.notifyBuffering(channelId, times, ms);
        }
    }

    public void updateChannel(int var1, String var2) {
        if (isLoad()) {
            jniApi.updateChannel(var1, var2);
        }
    }

    public boolean isBlockCached(int chanId, int blockId) {
        if (isLoad()) {
            return jniApi.isBlockCached(chanId, blockId);//没有返回0，有返回1
        }
        return false;
    }

    public void sendFrontLog(int chanId, String log) {
        if (isLoad()) {
            jniApi.sendFrontLog(chanId, log);
        }
    }

    public String getCurrentPrtId() {
        if (isLoad()) {
            return jniApi.getCurrentPrtId();
        }
        return "";
    }

    public int setAndGetPort(int port) {
        if (isLoad()) {
            return jniApi.setAndGetPort(port);
        }
        return -1;
    }

    public void initEngineProxyBuffer(int chanId, int blockLen, long resTotalLen, int solutionType, int solutionBrand, String drmKeyLink, int useBlockIdMap) {
        if (isLoad()) {
            jniApi.initEngineProxyBuffer(chanId, blockLen, resTotalLen, solutionType, solutionBrand, drmKeyLink, "", useBlockIdMap, 1, 0, 0);
        }
    }

    public void initEngineProxyBuffer(int chanId, int blockLen, long resTotalLen, int solutionType, int solutionBrand, String drmKeyLink, String streamKey, int useBlockIdMap, int proxyPushMode, int isAbr, int isMicroChan) {
        if (isLoad()) {
            jniApi.initEngineProxyBuffer(chanId, blockLen, resTotalLen, solutionType, solutionBrand, drmKeyLink, streamKey, useBlockIdMap, proxyPushMode, isAbr, isMicroChan);
        }
    }

    public void closeEngineProxyBuffer(int chanId) {
        if (isLoad()) {
            jniApi.closeEngineProxyBuffer(chanId);
        }
    }

    public void setBlockDecryptKey(int chanId, String key) {
        if (isLoad()) {
            jniApi.setBlockDecryptKey(chanId, key);
        }
    }

    private boolean isLoad() {
        if (!haveLoad) {
            logger.warn(TAG, "no load engine so");
        }
        return haveLoad;
    }

    public String getJniPathName() {
        return this.jniPathName;
    }

    public int getDownSpeed(int chanId) {
        if (isLoad()) {
            return jniApi.getDownSpeed(chanId);
        }
        return -1;
    }

    public int requestVodInfoToPlay(String channParams, String mptContent) {
        if (isLoad()) {
            return jniApi.requestVodInfoToPlay(channParams, mptContent);
        }
        return -1;
    }

    public int requestTimeShiftData(int chanId, long delay) {
        if (isLoad()) {
            return jniApi.requestTimeShiftData(chanId, delay);
        }
        return -1;
    }
}
