package com.stream.prt.utils;

/*
 * java数据类型工具类
 * create by zjb 2018.9.6
 * 使用ByteBuffer的接口来转换会额外申请内存,使用下面类,无需申请内存
 */
public class DataUtils {
    public static final int byte_len = 1;
    public static final int short_len = 2;
    public static final int int_len = 4;
    public static final int long_len = 8;
    private static final char[] HEX_CHAR = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    // 无符号数向右符号数转换
    public static int getUnsignedByte(byte data) { // 0~255
        return data & 0x0FF;
    }

    public static int getUnsignedShort(short data) { // 0~65535
        return data & 0x0FFFF;
    }

    public static long getUnsignedInt(int data) { // 0~4294967295
        return data & 0x0FFFFFFFFL;
    }

    // 有符号数的操作
    // 提取数据
    public static byte getByte(byte[] bytes, int offset) {
        return bytes[offset];
    }

    public static short getShort(byte[] bytes, int offset) {
        short result = (short) (((int) bytes[offset] & 0xff) << 8);
        result |= (short) (int) bytes[offset + 1] & 0xff;
        return (short) (result & 0xffff);
    }

    public static int getInt(byte[] bytes, int offset) {
        int result = (int) (bytes[offset] & 0xff) << 24;
        result |= ((int) bytes[offset + 1] & 0xff) << 16;
        result |= ((int) bytes[offset + 2] & 0xff) << 8;
        result |= ((int) bytes[offset + 3] & 0xff);
        return result;
    }

    public static long getLong(byte[] bytes, int offset) {
        long result = 0;
        for (int i = 0; i <= 56; i += 8) {
            result |= ((long) bytes[offset++] & 0xff) << (56 - i);
        }
        return result;
    }

    // 填数据
    public static int putByte(byte value, byte[] bytes, int offset) {
        bytes[offset] = value;
        return ++offset;
    }

    public static int putShort(short value, byte[] bytes, int offset) {
        bytes[offset++] = (byte) ((value & 0xff00) >> 8);
        bytes[offset++] = (byte) (value & 0xff);
        return offset;
    }

    public static int putInt(int value, byte[] bytes, int offset) {
        bytes[offset++] = (byte) ((value >>> 24)); //最高位，无符号右移
        bytes[offset++] = (byte) ((value >> 16) & 0xFF);
        bytes[offset++] = (byte) ((value >> 8) & 0xFF);
        bytes[offset++] = (byte) ((value) & 0xFF); //最低位
        return offset;
    }

    public static int putLong(long value, byte[] bytes, int offset) {
        for (int i = 0; i < 8; i++) {
            bytes[offset++] = (byte) ((value >> ((7 - i) * 8)) & 0xff);
        }

        return offset;
    }

    // 无符号BYTE/SHORT/INT
    // 思路:向高阶类型转换
    // 取数据
    public static short getUByte(byte[] bytes, int offset) {
        short result = (short) ((int) bytes[offset] & 0xff);
        return result;
    }

    public static int getUShort(byte[] bytes, int offset) {
        int result = ((int) bytes[offset] & 0xff) << 8;
        result |= ((int) bytes[offset + 1] & 0xff);
        return result & 0xffff;
    }

    public static long getUInt(byte[] bytes, int offset) {
        long result = ((long) bytes[offset] & 0xff) << 24;
        result |= ((int) bytes[offset + 1] & 0xff) << 16;
        result |= ((int) bytes[offset + 2] & 0xff) << 8;
        result |= ((int) bytes[offset + 3] & 0xff);
        return result & 0xFFFFFFFFL;
    }

    // 填数据
    public static int putUByte(short value, byte[] bytes, int offset) {
        bytes[offset++] = (byte) (value & 0xff);
        return offset;
    }

    public static int putUShort(int value, byte[] bytes, int offset) {
        bytes[offset++] = (byte) ((value & 0xff00) >> 8);
        bytes[offset++] = (byte) (value & 0xff);
        return offset;
    }

    public static int putUInt(long value, byte[] bytes, int offset) {
        bytes[offset++] = (byte) ((value >>> 24)); //最高位，无符号右移
        bytes[offset++] = (byte) ((value >> 16) & 0xFF);
        bytes[offset++] = (byte) ((value >> 8) & 0xFF);
        bytes[offset++] = (byte) ((value) & 0xFF); //最低位
        return offset;
    }

    /*
     * 二进制比较指定的长度
     */
    public static boolean compareArray(byte[] src1, int from1, byte[] src2, int from2, int len) {
        int len1 = src1.length;
        int len2 = src2.length;
        if ((from1 + len) > len1) {
            return false;
        }

        if ((from2 + len) > len2) {
            return false;
        }

        for (int i = 0; i < len; i++) {
            if (src1[from1++] != src2[from2++]) {
                return false;
            }
        }
        return true;
    }

    /*
     * 二进制数组向16进制字符串的转换
     */
    public static String bytesToHexString(byte[] data) {
        // 一个byte为8位，可用两个十六进制位标识
        char[] buf = new char[data.length * 2];
        int index = 0;
        for (byte b : data) {
            buf[index++] = HEX_CHAR[b >>> 4 & 0xf];
            buf[index++] = HEX_CHAR[b & 0xf];
        }

        return new String(buf);
    }

    /*
     * 字符串向二进制的转换
     */
    public static byte[] hexStringToBytes(String data) {
        int totals = data.length();
        if ((totals % 2) != 0) {
            return null;
        }
        byte[] value = new byte[totals / 2];
        byte[] bytes = data.getBytes();
        int i = 0;
        byte v = 0;
        for (int j = 0; j < totals; j++) {
            byte c = bytes[j];
            if ((c >= '0') && ((c <= '9'))) {
                c = (byte) (c - '0');
            } else if ((c >= 'a') && ((c <= 'f'))) {
                c = (byte) (c - 'a' + 10);
            } else if ((c >= 'A') && ((c <= 'F'))) {
                c = (byte) (c - 'A' + 10);
            } else {
                return null;
            }

            v = (byte) ((v << 4) | (c & 0x0f));
            if ((j % 2) != 0) {
                value[i] = v;
                i++;
            }
        }
        return value;
    }

    /*
     * 16进制字符串转换为long数字
     */
    public static long hexStringToLong(String data) {
        int totals = data.length();
        long result = 0;
        byte[] bytes = data.getBytes();
        int j = 0;
        if ((totals >= 2) && (bytes[0] == '0') && ((bytes[1] == 'x') || (bytes[1] == 'X'))) {
            j += 2;
        }

        for (; j < totals; j++) {
            byte c = bytes[j];
            if ((c >= '0') && ((c <= '9'))) {
                c = (byte) (c - '0');
            } else if ((c >= 'a') && ((c <= 'f'))) {
                c = (byte) (c - 'a' + 10);
            } else if ((c >= 'A') && ((c <= 'F'))) {
                c = (byte) (c - 'A' + 10);
            } else {
                return -1;
            }

            result = (result << 4) + c;
        }

        return result;
    }

    public static long stringToLong(String data, int fromPt) {
        long v = 0;
        int len = data.length();
        if (fromPt < 0) fromPt = 0;
        if (fromPt >= len) return 0;
        boolean bMinus = false;
        if (data.charAt(fromPt) == '-') {
            bMinus = true;
            fromPt++;
        }
        int nums = 0;
        for (int i = fromPt; i < len; i++) {
            char ch = data.charAt(i);
            if ((ch >= '0') && (ch <= '9')) {
                v = v * 10 + (ch - '0');
                nums++;
                continue;
            }
            if ((ch == ' ') && (nums == 0)) {
                // 可以过滤掉前导空格
                continue;
            }
            break;
        }

        return bMinus ? 0 - v : v;
    }

    // 2018-10-20 增加一个判断是否为null/空/空格这三种情况的函数
    // 相比常见的方法不用trim导致新产生对象
    public static boolean isNullEmptyBlank(String data) {
        if (data == null) {
            return true;
        }

        int iTotalLen = data.length();
        for (int i = 0; i < iTotalLen; i++) {
            if (data.charAt(i) != ' ') {
                return false;
            }
        }
        return true;
    }

    // 2018-10-20 去掉字符串的前后空格.StringUtils的trim函数效率非常低:不管是否有空格,都会new 2次对象
    public static String trimToNull(String data) {
        if (data == null) {
            return null;
        }

        int iTotalLen = data.length();
        int leftV = -1;
        int rightV = -1;
        for (int i = 0; i < iTotalLen; i++) {
            if (data.charAt(i) != ' ') {
                if (leftV == -1) {
                    leftV = i;
                }
                rightV = i;
            }
        }

        if (leftV == -1) {
            return null;
        }

        if ((leftV != 0) || ((rightV + 1) != iTotalLen)) {
            return data.substring(leftV, rightV + 1);
        }

        return data;
    }

    /*
     * 忽略大小写,比较16进制字符串,
     * 支持格式:
     * 1.0xabcd
     * 2.abcd
     * 要求必须都同时有或者同时没有0x
     */
    public static boolean compareHexString(String dt1, String dt2) {
        if ((dt1 == null) && (dt2 == null)) {
            return true;
        }

        if ((dt1 == null) || (dt2 == null)) {
            return false;
        }

        if (dt1.length() != dt2.length()) {
            return false;
        }

        byte[] dt1V = dt1.getBytes();
        byte[] dt2V = dt2.getBytes();
        int len = dt1.length();
        for (int i = 0; i < len; i++) {
            byte chV = dt1V[i];
            if (dt1V[i] == dt2V[i]) {
                // 相同的字符,不管
                continue;
            }
            if (chV == 'x') {
                chV = 'X';
            } else if (chV == 'X') {
                chV = 'x';
            } else if ((chV >= 'a') && (chV <= 'f')) {
                // 另外一部分可能是大写
                chV = (byte) ('A' + (chV - 'a'));
            } else if ((chV >= 'A') && (chV <= 'F')) {
                // 另外一部分可能是小写
                chV = (byte) ('a' + (chV - 'A'));
            } else {
                // 非16进制字符
                return false;
            }
            if (chV != dt2V[i]) {
                return false;
            }
        }

        return true;
    }
}