package com.stream.prt.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 * AES加密方法类 采用 AES/CTR/NOPADDING 方式加解密,特点： 1.加密前后的数据长度不变 2.原始数据无需16/32字节对齐
 */
public class AESSecurityPrt {

    /*
     * 加密
     */
    public static byte[] encrypt(String key, byte[] data, int len) {
        return JniApiImpl.getInstance().aesEncrypt(key.getBytes(), data, 0, 0);
    }

    public static String encryptToBase64(String key, byte[] data) {
        byte[] bytes = JniApiImpl.getInstance().aesEncrypt(key.getBytes(), data, 1, 1);
        return new String(bytes);
    }

    public static String decryptFromBase64(String key, String data) {
        byte[] bytes = JniApiImpl.getInstance().aesDecrypt(key.getBytes(), data.getBytes(), 1);
        return new String(bytes);
    }

    /*
     * 解密
     */
    public static byte[] decrypt(String key, byte[] data, int len) {
        return JniApiImpl.getInstance().aesDecrypt(key.getBytes(), data, 0);
    }
}