/*
 * Decompiled with CFR 0.152.
 */
package com.stream.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueProvider {
    private Map<String, String> properties = new HashMap<String, String>();
    private List<RefreshListener> listeners = new ArrayList<RefreshListener>();

    public void addRefreshListener(RefreshListener listener) {
        this.listeners.add(listener);
    }

    public void removeRefreshListener(RefreshListener listener) {
        this.listeners.remove(listener);
    }

    private ValueProvider(Map<String, String> properties) {
        this.merge(properties);
    }

    public static ValueProvider provider(Map<String, String> properties) {
        return new ValueProvider(properties);
    }

    public ValueProvider merge(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.properties.putAll(properties);
        }
        for (RefreshListener listener : this.listeners) {
            listener.onValueRefresh(this);
        }
        return this;
    }

    public ValueProvider merge(ValueProvider provider) {
        this.merge(provider.properties);
        return this;
    }

    public <T> T val(String key, T dft) {
        return ValueProvider.getVal(this.properties, key, dft);
    }

    public static <T> T getVal(Map<String, String> properties, String key, T dft) {
        if (properties == null || properties.isEmpty()) {
            return dft;
        }
        String str = ValueProvider.trimToNull(properties.get(key));
        if (str == null) {
            return dft;
        }
        if (dft == null) {
            return null;
        }
        Class<?> clz = dft.getClass();
        try {
            if (clz.equals(String.class)) {
                return (T)str;
            }
            if (clz.equals(Integer.TYPE) || clz.equals(Integer.class)) {
                return (T)Integer.valueOf(str);
            }
            if (clz.equals(Long.TYPE) || clz.equals(Long.class)) {
                return (T)Long.valueOf(str);
            }
            if (clz.equals(Float.TYPE) || clz.equals(Float.class)) {
                return (T)Float.valueOf(str);
            }
            if (clz.equals(Short.TYPE) || clz.equals(Short.class)) {
                return (T)Short.valueOf(str);
            }
            if (clz.equals(Double.TYPE) || clz.equals(Double.class)) {
                return (T)Double.valueOf(str);
            }
            if (clz.equals(Boolean.TYPE) || clz.equals(Boolean.class)) {
                return (T)Boolean.valueOf(str);
            }
            if (clz.equals(Byte.TYPE) || clz.equals(Byte.class)) {
                return (T)Byte.valueOf(str);
            }
            if (clz.equals(Character.TYPE)) {
                return (T)Character.valueOf(str.charAt(0));
            }
            return (T)str;
        }
        catch (Throwable ignored) {
            return dft;
        }
    }

    private static String trimToNull(String str) {
        if (str == null) {
            return null;
        }
        String trim = str.trim();
        if ("".equals(trim)) {
            return null;
        }
        return trim;
    }

    public String toString() {
        return "ValueProvider{properties=" + this.properties + '}';
    }

    public static interface RefreshListener {
        public void onValueRefresh(ValueProvider var1);
    }
}

