/*
 * Decompiled with CFR 0.152.
 */
package com.stream.tool.log;

import com.stream.tool.log.LoggerInterface;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Logger {
    public static final int NONE = 1;
    public static final int TRACE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile("(\\$\\d+)+$");
    private static LoggerInterface listener;
    private static int LOG_LEVEL;
    private String tag;

    public static Logger newInstance(String tag) {
        return new Logger(tag);
    }

    public Logger(String tag) {
        this.tag = tag;
    }

    public static void setLogger(LoggerInterface logger) {
        listener = logger;
    }

    public static LoggerInterface getLogger() {
        return listener;
    }

    public static void logLevel(int level) {
        if (level < 1 || level > 6) {
            throw new IllegalArgumentException("log level should between NONE-2 and ERROR-6");
        }
        LOG_LEVEL = level;
    }

    public void log(int priority, String tag, String message, Throwable t) {
        if (listener != null) {
            listener.log(priority, tag, message, t);
        }
    }

    public void trace(String message, Object ... args) {
        this.prepareLog(2, null, message, args);
    }

    public void trace(Throwable t, String message, Object ... args) {
        this.prepareLog(2, t, message, args);
    }

    public void debug(String message, Object ... args) {
        this.prepareLog(3, null, message, args);
    }

    public void debug(Throwable t, String message, Object ... args) {
        this.prepareLog(3, t, message, args);
    }

    public boolean isDebug() {
        return LOG_LEVEL <= 3;
    }

    public boolean isInfo() {
        return LOG_LEVEL <= 4;
    }

    public void info(String message, Object ... args) {
        this.prepareLog(4, null, message, args);
    }

    public void info(Throwable t, String message, Object ... args) {
        this.prepareLog(4, t, message, args);
    }

    public void warn(String message, Object ... args) {
        this.prepareLog(5, null, message, args);
    }

    public void warn(Throwable t, String message, Object ... args) {
        this.prepareLog(5, t, message, args);
    }

    public void error(String message, Object ... args) {
        this.prepareLog(6, null, message, args);
    }

    public void error(Throwable t, String message, Object ... args) {
        this.prepareLog(6, t, message, args);
    }

    private void prepareLog(int priority, Throwable t, String message, Object ... args) {
        try {
            if (listener != null && this.isLoggable(priority)) {
                if (message != null && message.length() == 0) {
                    message = null;
                }
                if (message == null) {
                    if (t == null) {
                        return;
                    }
                    message = this.getStackTraceString(t);
                } else {
                    if (args.length > 0) {
                        message = String.format(message, args);
                    }
                    if (t != null) {
                        message = message + "\n" + this.getStackTraceString(t);
                    }
                }
                this.log(priority, this.getTag(), message, t);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isLoggable(int priority) {
        return priority >= LOG_LEVEL;
    }

    private String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private String getTag() {
        if (this.tag != null && this.tag.length() > 0) {
            return this.tag;
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (stackTrace.length <= 5) {
            return "";
        }
        String tag = stackTrace[5].getClassName();
        Matcher m = ANONYMOUS_CLASS.matcher(tag);
        if (m.find()) {
            tag = m.replaceAll("");
        }
        return tag.substring(tag.lastIndexOf(46) + 1);
    }

    static {
        LOG_LEVEL = 5;
    }
}

