/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.Source;
import com.stripe.model.TopupCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.TopupCancelParams;
import com.stripe.param.TopupCreateParams;
import com.stripe.param.TopupListParams;
import com.stripe.param.TopupRetrieveParams;
import com.stripe.param.TopupUpdateParams;
import java.util.Map;
import lombok.Generated;

public class Topup
extends ApiResource
implements MetadataStore<Topup>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="expected_availability_date")
    Long expectedAvailabilityDate;
    @SerializedName(value="failure_code")
    String failureCode;
    @SerializedName(value="failure_message")
    String failureMessage;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="source")
    Source source;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transfer_group")
    String transferGroup;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public Topup cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Topup cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public Topup cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Topup cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/topups/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Topup.class, options);
    }

    public Topup cancel(TopupCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Topup cancel(TopupCancelParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/topups/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Topup.class, options);
    }

    public static Topup create(Map<String, Object> params) throws StripeException {
        return Topup.create(params, (RequestOptions)null);
    }

    public static Topup create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/topups");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Topup.class, options);
    }

    public static Topup create(TopupCreateParams params) throws StripeException {
        return Topup.create(params, (RequestOptions)null);
    }

    public static Topup create(TopupCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/topups");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Topup.class, options);
    }

    public static TopupCollection list(Map<String, Object> params) throws StripeException {
        return Topup.list(params, (RequestOptions)null);
    }

    public static TopupCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/topups");
        return ApiResource.requestCollection(url, params, TopupCollection.class, options);
    }

    public static TopupCollection list(TopupListParams params) throws StripeException {
        return Topup.list(params, (RequestOptions)null);
    }

    public static TopupCollection list(TopupListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/topups");
        return ApiResource.requestCollection(url, params, TopupCollection.class, options);
    }

    public static Topup retrieve(String topup) throws StripeException {
        return Topup.retrieve(topup, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Topup retrieve(String topup, RequestOptions options) throws StripeException {
        return Topup.retrieve(topup, (Map<String, Object>)null, options);
    }

    public static Topup retrieve(String topup, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/topups/%s", ApiResource.urlEncodeId(topup)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Topup.class, options);
    }

    public static Topup retrieve(String topup, TopupRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/topups/%s", ApiResource.urlEncodeId(topup)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Topup.class, options);
    }

    public Topup update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Topup update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/topups/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Topup.class, options);
    }

    public Topup update(TopupUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Topup update(TopupUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/topups/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Topup.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Long getExpectedAvailabilityDate() {
        return this.expectedAvailabilityDate;
    }

    @Generated
    public String getFailureCode() {
        return this.failureCode;
    }

    @Generated
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Source getSource() {
        return this.source;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setExpectedAvailabilityDate(Long expectedAvailabilityDate) {
        this.expectedAvailabilityDate = expectedAvailabilityDate;
    }

    @Generated
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    @Generated
    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setSource(Source source) {
        this.source = source;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Topup)) {
            return false;
        }
        Topup other = (Topup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expectedAvailabilityDate = this.getExpectedAvailabilityDate();
        Long other$expectedAvailabilityDate = other.getExpectedAvailabilityDate();
        if (this$expectedAvailabilityDate == null ? other$expectedAvailabilityDate != null : !((Object)this$expectedAvailabilityDate).equals(other$expectedAvailabilityDate)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$failureCode = this.getFailureCode();
        String other$failureCode = other.getFailureCode();
        if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
            return false;
        }
        String this$failureMessage = this.getFailureMessage();
        String other$failureMessage = other.getFailureMessage();
        if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Source this$source = this.getSource();
        Source other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        return !(this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Topup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expectedAvailabilityDate = this.getExpectedAvailabilityDate();
        result = result * 59 + ($expectedAvailabilityDate == null ? 43 : ((Object)$expectedAvailabilityDate).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $failureCode = this.getFailureCode();
        result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
        String $failureMessage = this.getFailureMessage();
        result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Source $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

