/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.ApplicationFee;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ApplicationFeeListParams;
import com.stripe.param.ApplicationFeeRetrieveParams;
import com.stripe.service.ApplicationFeeRefundService;
import java.lang.reflect.Type;

public final class ApplicationFeeService
extends ApiService {
    public ApplicationFeeService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<ApplicationFee> list(ApplicationFeeListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<ApplicationFee> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<ApplicationFee> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<ApplicationFee> list(ApplicationFeeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/application_fees";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<ApplicationFee>>(){}.getType());
    }

    public ApplicationFee retrieve(String id, ApplicationFeeRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public ApplicationFee retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public ApplicationFee retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public ApplicationFee retrieve(String id, ApplicationFeeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/application_fees/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (ApplicationFee)this.request(request, (Type)((Object)ApplicationFee.class));
    }

    public ApplicationFeeRefundService refunds() {
        return new ApplicationFeeRefundService(this.getResponseGetter());
    }
}

