/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.model;

import java.lang.reflect.InvocationTargetException;
import org.junit.ToBeImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectiveCallable {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectiveCallable.class);

    public Object run() throws Throwable {
        try {
            return this.runReflectiveCall();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ToBeImplementedException) {
                LOG.warn(t.getMessage());
            } else {
                LOG.error("{}", (Object)e.getCause(), (Object)t);
            }
            throw t;
        }
    }

    protected abstract Object runReflectiveCall() throws Throwable;
}

