/*
 * Copyright (c) 2015 - present Nebula Bay.
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tascape.reactor.comm;

import com.tascape.reactor.AbstractCaseResource;
import com.tascape.reactor.driver.EntityDriver;
import com.tascape.reactor.task.AbstractCase;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author linsong wang
 */
public abstract class EntityCommunication extends AbstractCaseResource {
    private static final Logger LOG = LoggerFactory.getLogger(EntityCommunication.class);

    private EntityDriver driver;

    private AbstractCase kase;

    public abstract void connect() throws Exception;

    public abstract void disconnect() throws Exception;

    public EntityDriver getDriver() {
        return driver;
    }

    public void setDriver(EntityDriver driver) {
        this.driver = driver;
    }

    public void setCase(AbstractCase kase) {
        this.kase = kase;
    }

    public AbstractCase getCase() {
        return kase;
    }

    @Override
    public Path getLogPath() {
        if (this.kase != null) {
            return this.kase.getLogPath();
        }
        if (this.driver != null) {
            return this.driver.getLogPath();
        }
        return super.getLogPath();
    }
}
