/*
 * Decompiled with CFR 0.152.
 */
package com.tascape.reactor;

import com.tascape.reactor.SystemConfiguration;
import com.tascape.reactor.Utils;
import java.awt.AWTException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCaseResource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCaseResource.class);
    public static final SystemConfiguration SYS_CONFIG = SystemConfiguration.getInstance();
    private static final ThreadLocal<Path> CASE_LOG_PATH = new ThreadLocal<Path>(){

        @Override
        protected Path initialValue() {
            String execId = SystemConfiguration.getInstance().getExecId();
            Path caseLogPath = SystemConfiguration.getInstance().getLogPath().resolve(execId);
            caseLogPath.toFile().mkdirs();
            return caseLogPath;
        }
    };
    protected final SystemConfiguration sysConfig = SystemConfiguration.getInstance();

    public static void setCaseLogPath(Path caseLogPath) {
        LOG.trace("Set runtime log directory {}: {}", (Object)Thread.currentThread().getName(), (Object)caseLogPath);
        CASE_LOG_PATH.set(caseLogPath);
    }

    public static Path getCaseLogPath() {
        return CASE_LOG_PATH.get();
    }

    public Path getLogPath() {
        return AbstractCaseResource.getCaseLogPath();
    }

    public File saveAsTextFile(String prefix, CharSequence data) throws IOException {
        return this.saveIntoFile(prefix, "txt", data);
    }

    public File saveIntoFile(String prefix, JSONObject json) throws IOException {
        return this.saveIntoFile(prefix, "json", json.toString(2));
    }

    public File saveIntoFile(String prefix, JSONArray json) throws IOException {
        return this.saveIntoFile(prefix, "json", json.toString(2));
    }

    public File saveIntoFile(String prefix, String suffix, CharSequence data) throws IOException {
        Path path = this.getLogPath();
        File p = path.toFile();
        if (!p.exists() && !p.mkdirs()) {
            throw new IOException("Cannot create log directory " + p);
        }
        File f = File.createTempFile(prefix + "-", "." + suffix, p);
        FileUtils.write((File)f, (CharSequence)data, (Charset)Charset.defaultCharset());
        LOG.debug("Save data into file {}", (Object)f.getAbsolutePath());
        return f;
    }

    public File saveAsTempTextFile(String filePrefix, CharSequence data) throws IOException {
        Path path = this.getLogPath();
        File f = File.createTempFile("lka_" + filePrefix, ".txt", path.toFile());
        FileUtils.write((File)f, (CharSequence)data, (Charset)Charset.defaultCharset());
        LOG.debug("Save data into file {}", (Object)f.getAbsolutePath());
        return f;
    }

    public File captureScreen() {
        Path path = this.getLogPath();
        File png = path.resolve("screen-" + System.currentTimeMillis() + ".png").toFile();
        png = Utils.getKeepAliveFile(png);
        try {
            Utils.captureScreen(png);
        }
        catch (AWTException | IOException ex) {
            LOG.warn("Cannot take screenshot", (Throwable)ex);
        }
        return png;
    }

    public void delay(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected File createDataFile(String prefix) throws IOException {
        return this.createDataFile(prefix, "txt");
    }

    protected File createDataFile(String prefix, String extension) throws IOException {
        File f = File.createTempFile(prefix + "-", "." + extension, this.getLogPath().toFile());
        return f;
    }

    protected File createKeepAliveLogFile(String prefix, String extension) throws IOException {
        File f = File.createTempFile(prefix + "-", "." + extension, this.getLogPath().toFile());
        return Utils.getKeepAliveFile(f);
    }
}

